/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.Watcher;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalZooKeeperCache
extends ZooKeeperCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalZooKeeperCache.class);

    public LocalZooKeeperCache(ZooKeeper zk, int zkOperationTimeoutSeconds, OrderedExecutor executor) {
        super("local-zk", zk, zkOperationTimeoutSeconds, executor);
    }

    @Override
    public <T> void process(WatchedEvent event, ZooKeeperCache.CacheUpdater<T> updater) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got Local ZooKeeper WatchedEvent: EventType: {}, KeeperState: {}, Path: {}", new Object[]{event.getType(), event.getState(), event.getPath()});
        }
        if (event.getType() == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case Expired: {
                    LOG.warn("Lost connection from local ZK. Invalidating the whole cache.");
                    this.dataCache.synchronous().invalidateAll();
                    this.childrenCache.synchronous().invalidateAll();
                    return;
                }
            }
        }
        super.process(event, updater);
    }
}

