/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.Watcher;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperManagedLedgerCache
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperManagedLedgerCache.class);
    private final ZooKeeperCache cache;
    private final String path;

    public ZooKeeperManagedLedgerCache(ZooKeeperCache cache, String path) {
        this.cache = cache;
        this.path = path;
    }

    public Set<String> get(String path) throws KeeperException, InterruptedException {
        Set<String> children;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getChildren called at: {}", (Object)path);
        }
        if ((children = this.cache.getChildrenAsync(path, this).join()) == null) {
            throw KeeperException.create(KeeperException.Code.NONODE);
        }
        return children;
    }

    public CompletableFuture<Set<String>> getAsync(String path) {
        return this.cache.getChildrenAsync(path, this);
    }

    public void clearTree() {
        this.cache.invalidateRoot(this.path);
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        LOG.info("[{}] Received ZooKeeper watch event: {}", (Object)this.cache.zkSession.get(), (Object)watchedEvent);
        String watchedEventPath = watchedEvent.getPath();
        if (watchedEventPath != null) {
            LOG.info("invalidate called in zookeeperChildrenCache for path {}", (Object)watchedEventPath);
            this.cache.invalidate(watchedEventPath);
        }
    }
}

