/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.digest.Crypt;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.digest.Md5Crypt;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;

public class AuthenticationProviderBasic
implements AuthenticationProvider {
    private static final String HTTP_HEADER_NAME = "Authorization";
    private static final String CONF_SYSTEM_PROPERTY_KEY = "pulsar.auth.basic.conf";
    private Map<String, String> users;

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ServiceConfiguration config) throws IOException {
        File confFile = new File(System.getProperty(CONF_SYSTEM_PROPERTY_KEY));
        if (!confFile.exists()) {
            throw new IOException("The password auth conf file does not exist");
        }
        if (!confFile.isFile()) {
            throw new IOException("The path is not a file");
        }
        BufferedReader reader = new BufferedReader(new FileReader(confFile));
        try {
            this.users = new HashMap<String, String>();
            for (String line : (String[])reader.lines().toArray(String[]::new)) {
                List<String> splitLine = Arrays.asList(line.split(":"));
                if (splitLine.size() != 2) {
                    throw new IOException("The format of the password auth conf file is invalid");
                }
                this.users.put(splitLine.get(0), splitLine.get(1));
            }
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    @Override
    public String getAuthMethodName() {
        return "basic";
    }

    @Override
    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        AuthParams authParams = new AuthParams(authData);
        String userId = authParams.getUserId();
        String password = authParams.getPassword();
        String msg = "Unknown user or invalid password";
        try {
            List<String> splitEncryptedPassword;
            if (this.users.get(userId) == null) {
                throw new AuthenticationException(msg);
            }
            String encryptedPassword = this.users.get(userId);
            if (this.users.get(userId).startsWith("$apr1") ? (splitEncryptedPassword = Arrays.asList(encryptedPassword.split("\\$"))).size() != 4 || !encryptedPassword.equals(Md5Crypt.apr1Crypt(password.getBytes(), splitEncryptedPassword.get(2))) : !encryptedPassword.equals(Crypt.crypt(password.getBytes(), encryptedPassword.substring(0, 2)))) {
                throw new AuthenticationException(msg);
            }
        }
        catch (AuthenticationException exception) {
            AuthenticationMetrics.authenticateFailure(this.getClass().getSimpleName(), this.getAuthMethodName(), exception.getMessage());
            throw exception;
        }
        AuthenticationMetrics.authenticateSuccess(this.getClass().getSimpleName(), this.getAuthMethodName());
        return userId;
    }

    private class AuthParams {
        private String userId;
        private String password;

        public AuthParams(AuthenticationDataSource authData) throws AuthenticationException {
            String authParams;
            if (authData.hasDataFromCommand()) {
                authParams = authData.getCommandData();
            } else if (authData.hasDataFromHttp()) {
                String rawAuthToken = authData.getHttpHeader(AuthenticationProviderBasic.HTTP_HEADER_NAME);
                if (StringUtils.isBlank(rawAuthToken) || !rawAuthToken.toUpperCase().startsWith("BASIC ")) {
                    throw new AuthenticationException("Authentication token has to be started with \"Basic \"");
                }
                String[] splitRawAuthToken = rawAuthToken.split(" ");
                if (splitRawAuthToken.length != 2) {
                    throw new AuthenticationException("Base64 encoded token is not found");
                }
                try {
                    authParams = new String(Base64.getDecoder().decode(splitRawAuthToken[1]));
                }
                catch (Exception e) {
                    throw new AuthenticationException("Base64 decoding is failure: " + e.getMessage());
                }
            } else {
                throw new AuthenticationException("Authentication data source does not have data");
            }
            String[] parsedAuthParams = authParams.split(":");
            if (parsedAuthParams.length != 2) {
                throw new AuthenticationException("Base64 decoded params are invalid");
            }
            this.userId = parsedAuthParams[0];
            this.password = parsedAuthParams[1];
        }

        public String getUserId() {
            return this.userId;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

