/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.apache.pulsar.client.api.url.URL;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.io.ByteStreams;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.JwtBuilder;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.Jwts;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.SignatureAlgorithm;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.io.Decoders;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.io.DecodingException;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.io.Encoders;
import org.apache.pulsar.functions.runtime.shaded.io.jsonwebtoken.security.Keys;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.codec.binary.Base64;

public final class AuthTokenUtils {
    public static SecretKey createSecretKey(SignatureAlgorithm signatureAlgorithm) {
        return Keys.secretKeyFor((SignatureAlgorithm)signatureAlgorithm);
    }

    public static SecretKey decodeSecretKey(byte[] secretKey) {
        return Keys.hmacShaKeyFor((byte[])secretKey);
    }

    public static PrivateKey decodePrivateKey(byte[] key, SignatureAlgorithm algType) throws IOException {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance(AuthTokenUtils.keyTypeForSignatureAlgorithm(algType));
            return kf.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new IOException("Failed to decode private key", e);
        }
    }

    public static PublicKey decodePublicKey(byte[] key, SignatureAlgorithm algType) throws IOException {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance(AuthTokenUtils.keyTypeForSignatureAlgorithm(algType));
            return kf.generatePublic(spec);
        }
        catch (Exception e) {
            throw new IOException("Failed to decode public key", e);
        }
    }

    private static String keyTypeForSignatureAlgorithm(SignatureAlgorithm alg) {
        if (alg.getFamilyName().equals("RSA")) {
            return "RSA";
        }
        if (alg.getFamilyName().equals("ECDSA")) {
            return "EC";
        }
        String msg = "The " + alg.name() + " algorithm does not support Key Pairs.";
        throw new IllegalArgumentException(msg);
    }

    public static String encodeKeyBase64(Key key) {
        return (String)Encoders.BASE64.encode((Object)key.getEncoded());
    }

    public static String createToken(Key signingKey, String subject, Optional<Date> expiryTime) {
        JwtBuilder builder = Jwts.builder().setSubject(subject).signWith(signingKey);
        expiryTime.ifPresent(arg_0 -> ((JwtBuilder)builder).setExpiration(arg_0));
        return builder.compact();
    }

    public static byte[] readKeyFromUrl(String keyConfUrl) throws IOException {
        if (keyConfUrl.startsWith("data:") || keyConfUrl.startsWith("file:")) {
            try {
                return ByteStreams.toByteArray((InputStream)new URL(keyConfUrl).getContent());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (Files.exists(Paths.get(keyConfUrl, new String[0]), new LinkOption[0])) {
            try {
                return Files.readAllBytes(Paths.get(keyConfUrl, new String[0]));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        if (Base64.isBase64(keyConfUrl.getBytes())) {
            try {
                return (byte[])Decoders.BASE64.decode((Object)keyConfUrl);
            }
            catch (DecodingException e) {
                String msg = "Illegal base64 character or Key file " + keyConfUrl + " doesn't exist";
                throw new IOException(msg, e);
            }
        }
        String msg = "Secret/Public Key file " + keyConfUrl + " doesn't exist";
        throw new IllegalArgumentException(msg);
    }

    private AuthTokenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

