/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceResources
extends BaseResources<Policies> {
    private static final Logger log = LoggerFactory.getLogger(NamespaceResources.class);
    private final IsolationPolicyResources isolationPolicies;
    private final PartitionedTopicResources partitionedTopicResources;
    private final MetadataStore configurationStore;
    private final MetadataCache<LocalPolicies> localPoliciesCache;
    private static final String POLICIES_READONLY_FLAG_PATH = "/admin/flags/policies-readonly";
    private static final String NAMESPACE_BASE_PATH = "/namespace";
    private static final String BUNDLE_DATA_BASE_PATH = "/loadbalance/bundle-data";

    public NamespaceResources(MetadataStore localStore, MetadataStore configurationStore, int operationTimeoutSec) {
        super(configurationStore, Policies.class, operationTimeoutSec);
        this.configurationStore = configurationStore;
        this.isolationPolicies = new IsolationPolicyResources(configurationStore, operationTimeoutSec);
        this.partitionedTopicResources = new PartitionedTopicResources(configurationStore, operationTimeoutSec);
        this.localPoliciesCache = localStore != null ? localStore.getMetadataCache(LocalPolicies.class) : null;
    }

    public CompletableFuture<List<String>> listNamespacesAsync(String tenant) {
        return this.getChildrenAsync(NamespaceResources.joinPath("/admin/policies", tenant));
    }

    public boolean getPoliciesReadOnly() throws MetadataStoreException {
        return super.exists(POLICIES_READONLY_FLAG_PATH);
    }

    public void createPolicies(NamespaceName ns, Policies policies) throws MetadataStoreException {
        this.create(NamespaceResources.joinPath("/admin/policies", ns.toString()), policies);
    }

    public boolean namespaceExists(NamespaceName ns) throws MetadataStoreException {
        String path = NamespaceResources.joinPath("/admin/policies", ns.toString());
        return super.exists(path) && super.getChildren(path).isEmpty();
    }

    public CompletableFuture<Boolean> namespaceExistsAsync(NamespaceName ns) {
        String path = NamespaceResources.joinPath("/admin/policies", ns.toString());
        return this.getCache().exists(path).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return this.getChildrenAsync(path).thenApply(children -> children.isEmpty());
        });
    }

    public void deletePolicies(NamespaceName ns) throws MetadataStoreException {
        this.delete(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public CompletableFuture<Void> deletePoliciesAsync(NamespaceName ns) {
        return this.deleteAsync(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public Optional<Policies> getPolicies(NamespaceName ns) throws MetadataStoreException {
        return this.get(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public Optional<Policies> getPoliciesIfCached(NamespaceName ns) {
        return this.getCache().getIfCached(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public CompletableFuture<Optional<Policies>> getPoliciesAsync(NamespaceName ns) {
        return this.getCache().get(NamespaceResources.joinPath("/admin/policies", ns.toString()));
    }

    public void setPolicies(NamespaceName ns, Function<Policies, Policies> function) throws MetadataStoreException {
        this.set(NamespaceResources.joinPath("/admin/policies", ns.toString()), function);
    }

    public CompletableFuture<Void> setPoliciesAsync(NamespaceName ns, Function<Policies, Policies> function) {
        return this.setAsync(NamespaceResources.joinPath("/admin/policies", ns.toString()), function);
    }

    public static boolean pathIsFromNamespace(String path) {
        return path.startsWith("/admin/policies/") && path.substring("/admin/policies".length() + 1).contains("/");
    }

    public CompletableFuture<Void> deleteNamespaceAsync(NamespaceName ns) {
        String namespacePath = NamespaceResources.joinPath(NAMESPACE_BASE_PATH, ns.toString());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.deleteAsync(namespacePath).whenComplete((ignore, ex) -> {
            if (ex != null && ex.getCause().getCause() instanceof KeeperException.NoNodeException) {
                future.complete(null);
            } else if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public CompletableFuture<Void> deleteTenantAsync(String tenant) {
        String tenantPath = NamespaceResources.joinPath(NAMESPACE_BASE_PATH, tenant);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.deleteAsync(tenantPath).whenComplete((ignore, ex) -> {
            if (ex != null && ex.getCause().getCause() instanceof KeeperException.NoNodeException) {
                future.complete(null);
            } else if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public static NamespaceName namespaceFromPath(String path) {
        return NamespaceName.get(path.substring("/admin/policies".length() + 1));
    }

    public CompletableFuture<Void> deleteBundleDataAsync(NamespaceName ns) {
        String namespaceBundlePath = NamespaceResources.joinPath(BUNDLE_DATA_BASE_PATH, ns.toString());
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        NamespaceResources.deleteRecursiveAsync(this, namespaceBundlePath).whenComplete((ignore, ex) -> {
            if (ex instanceof MetadataStoreException.NotFoundException) {
                future.complete(null);
            } else if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public CompletableFuture<Void> deleteBundleDataTenantAsync(String tenant) {
        String tenantBundlePath = NamespaceResources.joinPath(BUNDLE_DATA_BASE_PATH, tenant);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        NamespaceResources.deleteRecursiveAsync(this, tenantBundlePath).whenComplete((ignore, ex) -> {
            if (ex instanceof MetadataStoreException.NotFoundException) {
                future.complete(null);
            } else if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public IsolationPolicyResources getIsolationPolicies() {
        return this.isolationPolicies;
    }

    public PartitionedTopicResources getPartitionedTopicResources() {
        return this.partitionedTopicResources;
    }

    public MetadataStore getConfigurationStore() {
        return this.configurationStore;
    }

    public MetadataCache<LocalPolicies> getLocalPoliciesCache() {
        return this.localPoliciesCache;
    }

    public static class PartitionedTopicResources
    extends BaseResources<PartitionedTopicMetadata> {
        private static final String PARTITIONED_TOPIC_PATH = "/admin/partitioned-topics";

        public PartitionedTopicResources(MetadataStore configurationStore, int operationTimeoutSec) {
            super(configurationStore, PartitionedTopicMetadata.class, operationTimeoutSec);
        }

        public CompletableFuture<Void> updatePartitionedTopicAsync(TopicName tn, Function<PartitionedTopicMetadata, PartitionedTopicMetadata> f) {
            return this.setAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()), f);
        }

        public void createPartitionedTopic(TopicName tn, PartitionedTopicMetadata tm) throws MetadataStoreException {
            this.create(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()), tm);
        }

        public CompletableFuture<Void> createPartitionedTopicAsync(TopicName tn, PartitionedTopicMetadata tm) {
            return this.createAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()), tm);
        }

        public CompletableFuture<List<String>> listPartitionedTopicsAsync(NamespaceName ns, TopicDomain domain) {
            return this.getChildrenAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, ns.toString(), domain.value())).thenApply(list -> list.stream().map(x -> TopicName.get(domain.value(), ns, Codec.decode(x)).toString()).collect(Collectors.toList()));
        }

        public CompletableFuture<Optional<PartitionedTopicMetadata>> getPartitionedTopicMetadataAsync(TopicName tn) {
            return this.getAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public boolean partitionedTopicExists(TopicName tn) throws MetadataStoreException {
            return this.exists(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public CompletableFuture<Boolean> partitionedTopicExistsAsync(TopicName tn) {
            return this.existsAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public CompletableFuture<Void> deletePartitionedTopicAsync(TopicName tn) {
            return this.deleteAsync(PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, tn.getNamespace(), tn.getDomain().value(), tn.getEncodedLocalName()));
        }

        public CompletableFuture<Void> clearPartitionedTopicMetadataAsync(NamespaceName namespaceName) {
            String globalPartitionedPath = PartitionedTopicResources.joinPath(PARTITIONED_TOPIC_PATH, namespaceName.toString());
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            ((CompletableFuture)PartitionedTopicResources.deleteRecursiveAsync(this, globalPartitionedPath).thenAccept(ignore -> {
                log.info("Clear partitioned topic metadata [{}] success.", (Object)namespaceName);
                completableFuture.complete(null);
            })).exceptionally(ex -> {
                if (!(ex.getCause().getCause() instanceof KeeperException.NoNodeException)) {
                    log.error("Clear partitioned topic metadata failed.");
                    completableFuture.completeExceptionally(ex.getCause());
                    return null;
                }
                completableFuture.complete(null);
                return null;
            });
            return completableFuture;
        }
    }

    public static class IsolationPolicyResources
    extends BaseResources<Map<String, NamespaceIsolationDataImpl>> {
        private static final String NAMESPACE_ISOLATION_POLICIES = "namespaceIsolationPolicies";

        public IsolationPolicyResources(MetadataStore store, int operationTimeoutSec) {
            super(store, new TypeReference<Map<String, NamespaceIsolationDataImpl>>(){}, operationTimeoutSec);
        }

        public Optional<NamespaceIsolationPolicies> getIsolationDataPolicies(String cluster) throws MetadataStoreException {
            Optional data = super.get(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES));
            return data.isPresent() ? Optional.of(new NamespaceIsolationPolicies((Map)data.get())) : Optional.empty();
        }

        public void deleteIsolationData(String cluster) throws MetadataStoreException {
            this.delete(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES));
        }

        public void createIsolationData(String cluster, Map<String, NamespaceIsolationDataImpl> id) throws MetadataStoreException {
            this.create(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), id);
        }

        public void setIsolationData(String cluster, Function<Map<String, NamespaceIsolationDataImpl>, Map<String, NamespaceIsolationDataImpl>> modifyFunction) throws MetadataStoreException {
            this.set(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), modifyFunction);
        }

        public void setIsolationDataWithCreate(String cluster, Function<Optional<Map<String, NamespaceIsolationDataImpl>>, Map<String, NamespaceIsolationDataImpl>> createFunction) throws MetadataStoreException {
            this.setWithCreate(IsolationPolicyResources.joinPath("/admin/clusters", cluster, NAMESPACE_ISOLATION_POLICIES), createFunction);
        }
    }
}

