/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.validator;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Maps;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Sets;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;

public final class MultipleListenerValidator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, AdvertisedListener> validateAndAnalysisAdvertisedListener(ServiceConfiguration config) {
        void var1_2;
        if (StringUtils.isBlank(config.getAdvertisedListeners())) {
            return Collections.emptyMap();
        }
        Optional optional = Optional.empty();
        LinkedHashMap<String, List> listeners = Maps.newLinkedHashMap();
        for (String str : StringUtils.split(config.getAdvertisedListeners(), ",")) {
            int index = str.indexOf(":");
            if (index <= 0) {
                throw new IllegalArgumentException("the configure entry `advertisedListeners` is invalid. because " + str + " do not contain listener name");
            }
            String listenerName = StringUtils.trim(str.substring(0, index));
            if (!var1_2.isPresent()) {
                Optional<String> optional2 = Optional.of(listenerName);
            }
            String value = StringUtils.trim(str.substring(index + 1));
            listeners.computeIfAbsent(listenerName, k -> Lists.newArrayListWithCapacity(2));
            ((List)listeners.get(listenerName)).add(value);
        }
        if (StringUtils.isBlank(config.getInternalListenerName())) {
            config.setInternalListenerName((String)var1_2.get());
        }
        if (!listeners.containsKey(config.getInternalListenerName())) {
            throw new IllegalArgumentException("the `advertisedListeners` configure do not contain `internalListenerName` entry");
        }
        LinkedHashMap<String, AdvertisedListener> result = Maps.newLinkedHashMap();
        LinkedHashMap<String, Set> reverseMappings = Maps.newLinkedHashMap();
        for (Map.Entry entry : listeners.entrySet()) {
            if (((List)entry.getValue()).size() > 2) {
                throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
            }
            URI pulsarAddress = null;
            URI pulsarSslAddress = null;
            URI pulsarHttpAddress = null;
            URI pulsarHttpsAddress = null;
            for (String strUri : (List)entry.getValue()) {
                try {
                    URI uri = URI.create(strUri);
                    if (StringUtils.equalsIgnoreCase(uri.getScheme(), "pulsar")) {
                        if (pulsarAddress != null) throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
                        pulsarAddress = uri;
                    } else if (StringUtils.equalsIgnoreCase(uri.getScheme(), "pulsar+ssl")) {
                        if (pulsarSslAddress != null) throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
                        pulsarSslAddress = uri;
                    } else if (StringUtils.equalsIgnoreCase(uri.getScheme(), "http")) {
                        if (pulsarHttpAddress != null) throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
                        pulsarHttpAddress = uri;
                    } else if (StringUtils.equalsIgnoreCase(uri.getScheme(), "https")) {
                        if (pulsarHttpsAddress != null) throw new IllegalArgumentException("there are redundant configure for listener `" + (String)entry.getKey() + "`");
                        pulsarHttpsAddress = uri;
                    }
                    String hostPort = String.format("%s:%d", uri.getHost(), uri.getPort());
                    Set sets = reverseMappings.computeIfAbsent(hostPort, k -> Sets.newTreeSet());
                    sets.add(entry.getKey());
                    if (sets.size() <= 1) continue;
                    throw new IllegalArgumentException("must not specify `" + hostPort + "` to different listener.");
                }
                catch (Throwable cause) {
                    throw new IllegalArgumentException("the value " + strUri + " in the `advertisedListeners` configure is invalid", cause);
                }
            }
            result.put((String)entry.getKey(), AdvertisedListener.builder().brokerServiceUrl(pulsarAddress).brokerServiceUrlTls(pulsarSslAddress).brokerHttpUrl(pulsarHttpAddress).brokerHttpsUrl(pulsarHttpsAddress).build());
        }
        return result;
    }
}

