/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Properties;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.util.FieldParser;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarConfigurationLoader {
    private static final Logger log = LoggerFactory.getLogger(PulsarConfigurationLoader.class);

    public static <T extends PulsarConfiguration> T create(String configFile, Class<? extends PulsarConfiguration> clazz) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull(configFile);
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            T t = PulsarConfigurationLoader.create(inputStream, clazz);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PulsarConfiguration> T create(InputStream inStream, Class<? extends PulsarConfiguration> clazz) throws IOException, IllegalArgumentException {
        try {
            Preconditions.checkNotNull(inStream);
            Properties properties = new Properties();
            properties.load(inStream);
            T t = PulsarConfigurationLoader.create(properties, clazz);
            return t;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static <T extends PulsarConfiguration> T create(Properties properties, Class<? extends PulsarConfiguration> clazz) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull(properties);
        PulsarConfiguration configuration = null;
        try {
            configuration = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            configuration.setProperties(properties);
            FieldParser.update(properties, configuration);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz.getName(), e);
        }
        return (T)configuration;
    }

    public static boolean isComplete(Object obj) throws IllegalArgumentException {
        Preconditions.checkNotNull(obj);
        Field[] fields = obj.getClass().getDeclaredFields();
        StringBuilder error = new StringBuilder();
        for (Field field : fields) {
            boolean valid;
            Object value;
            if (!field.isAnnotationPresent(FieldContext.class)) continue;
            field.setAccessible(true);
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug("Validating configuration field '{}' = '{}'", (Object)field.getName(), value);
            }
            boolean isRequired = field.getAnnotation(FieldContext.class).required();
            long minValue = field.getAnnotation(FieldContext.class).minValue();
            long maxValue = field.getAnnotation(FieldContext.class).maxValue();
            if (isRequired && PulsarConfigurationLoader.isEmpty(value)) {
                error.append(String.format("Required %s is null,", field.getName()));
            }
            if (value == null || !Number.class.isAssignableFrom(value.getClass())) continue;
            long fieldVal = ((Number)value).longValue();
            boolean bl = valid = fieldVal >= minValue && fieldVal <= maxValue;
            if (valid) continue;
            error.append(String.format("%s value %d doesn't fit in given range (%d, %d),", field.getName(), fieldVal, minValue, maxValue));
        }
        if (error.length() > 0) {
            throw new IllegalArgumentException(error.substring(0, error.length() - 1));
        }
        return true;
    }

    private static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isBlank((String)obj);
        }
        return false;
    }

    public static ServiceConfiguration convertFrom(PulsarConfiguration conf, boolean ignoreNonExistMember) throws RuntimeException {
        try {
            ServiceConfiguration convertedConf = (ServiceConfiguration)ServiceConfiguration.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] confFields = conf.getClass().getDeclaredFields();
            Arrays.stream(confFields).forEach(confField -> {
                try {
                    Field convertedConfField = ServiceConfiguration.class.getDeclaredField(confField.getName());
                    confField.setAccessible(true);
                    if (!Modifier.isStatic(convertedConfField.getModifiers())) {
                        convertedConfField.setAccessible(true);
                        convertedConfField.set(convertedConf, confField.get(conf));
                    }
                }
                catch (NoSuchFieldException e) {
                    if (!ignoreNonExistMember) {
                        throw new IllegalArgumentException("Exception caused while converting configuration: " + e.getMessage());
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Exception caused while converting configuration: " + e.getMessage());
                }
            });
            return convertedConf;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Exception caused while converting configuration: " + e.getMessage());
        }
    }

    public static ServiceConfiguration convertFrom(PulsarConfiguration conf) throws RuntimeException {
        return PulsarConfigurationLoader.convertFrom(conf, true);
    }
}

