/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.pulsar.functions.api.StateStore;
import org.apache.pulsar.functions.instance.state.StateManager;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceStateManager
implements StateManager {
    private static final Logger log = LoggerFactory.getLogger(InstanceStateManager.class);
    private final Map<String, StateStore> stores = new LinkedHashMap<String, StateStore>();

    @VisibleForTesting
    boolean isEmpty() {
        return this.stores.isEmpty();
    }

    @Override
    public void registerStore(StateStore store) {
        String storeName = store.fqsn();
        Preconditions.checkArgument(!this.stores.containsKey(storeName), String.format("Store %s has already been registered.", storeName));
        this.stores.put(storeName, store);
    }

    @Override
    public StateStore getStore(String tenant, String namespace, String name) {
        String storeName = FunctionCommon.getFullyQualifiedName(tenant, namespace, name);
        return this.stores.get(storeName);
    }

    @Override
    public void close() {
        RuntimeException firstException = null;
        for (Map.Entry<String, StateStore> entry : this.stores.entrySet()) {
            StateStore store = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug("Closing store {}", (Object)store.fqsn());
            }
            try {
                store.close();
            }
            catch (RuntimeException e) {
                if (firstException == null) {
                    firstException = e;
                }
                log.error("Failed to close state store {}: ", (Object)store.fqsn(), (Object)e);
            }
        }
        this.stores.clear();
        if (null != firstException) {
            throw firstException;
        }
    }
}

