/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryLogCompactor
extends AbstractLogCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(EntryLogCompactor.class);
    final CompactionScannerFactory scannerFactory = new CompactionScannerFactory();
    final EntryLogger entryLogger;
    final CompactableLedgerStorage ledgerStorage;
    private final int maxOutstandingRequests;

    public EntryLogCompactor(ServerConfiguration conf, EntryLogger entryLogger, CompactableLedgerStorage ledgerStorage, AbstractLogCompactor.LogRemovalListener logRemover) {
        super(conf, logRemover);
        this.maxOutstandingRequests = conf.getCompactionMaxOutstandingRequests();
        this.entryLogger = entryLogger;
        this.ledgerStorage = ledgerStorage;
    }

    @Override
    public boolean compact(EntryLogMetadata entryLogMeta) {
        try {
            this.entryLogger.scanEntryLog(entryLogMeta.getEntryLogId(), this.scannerFactory.newScanner(entryLogMeta));
            this.scannerFactory.flush();
            LOG.info("Removing entry log {} after compaction", (Object)entryLogMeta.getEntryLogId());
            this.logRemovalListener.removeEntryLog(entryLogMeta.getEntryLogId());
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException nwlde) {
            LOG.warn("No writable ledger directory available, aborting compaction", (Throwable)nwlde);
            return false;
        }
        catch (IOException ioe) {
            LOG.error("Error compacting entry log. Log won't be deleted", (Throwable)ioe);
            return false;
        }
        return true;
    }

    class CompactionScannerFactory {
        List<EntryLocation> offsets = new ArrayList<EntryLocation>();

        CompactionScannerFactory() {
        }

        EntryLogger.EntryLogScanner newScanner(final EntryLogMetadata meta) {
            return new EntryLogger.EntryLogScanner(){

                @Override
                public boolean accept(long ledgerId) {
                    return meta.containsLedger(ledgerId);
                }

                @Override
                public void process(long ledgerId, long offset, ByteBuf entry) throws IOException {
                    EntryLogCompactor.this.throttler.acquire(entry.readableBytes());
                    if (CompactionScannerFactory.this.offsets.size() > EntryLogCompactor.this.maxOutstandingRequests) {
                        CompactionScannerFactory.this.flush();
                    }
                    long entryId = entry.getLong(entry.readerIndex() + 8);
                    long newoffset = EntryLogCompactor.this.entryLogger.addEntry(ledgerId, entry);
                    CompactionScannerFactory.this.offsets.add(new EntryLocation(ledgerId, entryId, newoffset));
                }
            };
        }

        void flush() throws IOException {
            if (this.offsets.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping entry log flushing, as there are no offset!");
                }
                return;
            }
            try {
                EntryLogCompactor.this.entryLogger.flush();
                EntryLogCompactor.this.ledgerStorage.updateEntriesLocations(this.offsets);
                EntryLogCompactor.this.ledgerStorage.flushEntriesLocationsIndex();
            }
            finally {
                this.offsets.clear();
            }
        }
    }
}

