/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.stats;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.ForwardingServerCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Metadata;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Status;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.grpc.stats.ServerStats;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.MathUtils;

class MonitoringServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final ServerStats stats;
    private final long startNanos;

    MonitoringServerCall(ServerCall<ReqT, RespT> delegate, ServerStats stats) {
        super(delegate);
        this.stats = stats;
        this.startNanos = MathUtils.nowInNano();
        stats.recordCallStarted();
    }

    public void sendMessage(RespT message) {
        this.stats.recordStreamMessageSent();
        super.sendMessage(message);
    }

    public void close(Status status, Metadata trailers) {
        this.stats.recordServerHandled(status.getCode());
        if (this.stats.shouldRecordLatency()) {
            long latencyMicros = MathUtils.elapsedMicroSec(this.startNanos);
            this.stats.recordLatency(Status.OK == status, latencyMicros);
        }
        super.close(status, trailers);
    }
}

