/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.resolver;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Attributes;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.EquivalentAddressGroup;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.resolver.AbstractNameResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.SharedResourceManager;

public class StaticNameResolver
extends AbstractNameResolver {
    private final List<EquivalentAddressGroup> servers;

    public StaticNameResolver(String name, SharedResourceManager.Resource<ExecutorService> executorResource, List<URI> endpoints) {
        super(name, executorResource);
        this.servers = Collections.unmodifiableList(endpoints.stream().map(endpoint -> new EquivalentAddressGroup(Lists.newArrayList(new InetSocketAddress(endpoint.getHost(), endpoint.getPort())), Attributes.EMPTY)).collect(Collectors.toList()));
    }

    @Override
    public List<EquivalentAddressGroup> getServers() {
        return this.servers;
    }
}

