/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.sasl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.auth.AuthToken;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.sasl.SaslClientState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SASLClientAuthProvider
implements ClientAuthProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SASLClientAuthProvider.class);
    private SaslClientState client;
    private final AuthCallbacks.GenericCallback<Void> completeCb;

    SASLClientAuthProvider(ClientConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb, Subject subject) {
        this.completeCb = completeCb;
        try {
            String hostname;
            SocketAddress remoteAddr = addr.getRemoteAddr();
            if (remoteAddr instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddr;
                hostname = inetSocketAddress.getHostName();
            } else {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            this.client = new SaslClientState(hostname, subject);
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASLClientAuthProvider Boot " + this.client + " for " + hostname);
            }
        }
        catch (IOException error) {
            LOG.error("Error while booting SASL client", (Throwable)error);
            completeCb.operationComplete(-102, null);
        }
    }

    @Override
    public void init(AuthCallbacks.GenericCallback<AuthToken> cb) {
        try {
            if (this.client.hasInitialResponse()) {
                byte[] response = this.client.evaluateChallenge(new byte[0]);
                cb.operationComplete(0, AuthToken.wrap(response));
            } else {
                cb.operationComplete(0, AuthToken.wrap(new byte[0]));
            }
        }
        catch (SaslException err) {
            LOG.error("Error on SASL client", (Throwable)err);
            this.completeCb.operationComplete(-102, null);
        }
    }

    @Override
    public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
        if (this.client.isComplete()) {
            this.completeCb.operationComplete(0, null);
            return;
        }
        try {
            byte[] responseToken = m.getData();
            byte[] response = this.client.evaluateChallenge(responseToken);
            if (response == null) {
                response = new byte[]{};
            }
            cb.operationComplete(0, AuthToken.wrap(response));
            if (this.client.isComplete()) {
                this.completeCb.operationComplete(0, null);
            }
        }
        catch (SaslException err) {
            LOG.error("Error on SASL client", (Throwable)err);
            this.completeCb.operationComplete(-102, null);
        }
    }
}

