/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.sasl;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.auth.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerState {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerState.class);
    private final SaslServer saslServer;
    private final Pattern allowedIdsPattern;

    public SaslServerState(ServerConfiguration serverConfiguration, Subject subject, Pattern allowedIdsPattern) throws IOException, SaslException, LoginException {
        this.allowedIdsPattern = allowedIdsPattern;
        this.saslServer = this.createSaslServer(subject, serverConfiguration);
    }

    private SaslServer createSaslServer(Subject subject, ServerConfiguration serverConfiguration) throws SaslException, IOException {
        final SaslServerCallbackHandler callbackHandler = new SaslServerCallbackHandler(Configuration.getConfiguration(), serverConfiguration);
        if (subject.getPrincipals().size() > 0) {
            try {
                String serviceHostname;
                String servicePrincipalName;
                Object[] principals = subject.getPrincipals().toArray();
                Principal servicePrincipal = (Principal)principals[0];
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication will use SASL/JAAS/Kerberos, servicePrincipal is {}", (Object)servicePrincipal);
                }
                String servicePrincipalNameAndHostname = servicePrincipal.getName();
                int indexOf = servicePrincipalNameAndHostname.indexOf("/");
                String serviceHostnameAndKerbDomain = servicePrincipalNameAndHostname.substring(indexOf + 1, servicePrincipalNameAndHostname.length());
                int indexOfAt = serviceHostnameAndKerbDomain.indexOf("@");
                if (indexOf > 0) {
                    servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOf);
                    serviceHostname = serviceHostnameAndKerbDomain.substring(0, indexOfAt);
                } else {
                    servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOfAt);
                    serviceHostname = null;
                }
                try {
                    return Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                        @Override
                        public SaslServer run() {
                            try {
                                SaslServer saslServer = Sasl.createSaslServer("GSSAPI", servicePrincipalName, serviceHostname, null, callbackHandler);
                                return saslServer;
                            }
                            catch (SaslException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new SaslException("error on GSSAPI boot", e.getCause());
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new SaslException("error on GSSAPI boot", e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication will use SASL/JAAS/DIGEST-MD5");
        }
        return Sasl.createSaslServer("DIGEST-MD5", "bookkeeper", "bookkeeper", null, callbackHandler);
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getUserName() {
        return this.saslServer.getAuthorizationID();
    }

    public byte[] response(byte[] token) throws SaslException {
        try {
            byte[] retval = this.saslServer.evaluateResponse(token);
            return retval;
        }
        catch (SaslException e) {
            LOG.error("response: Failed to evaluate client token", (Throwable)e);
            throw e;
        }
    }

    private class SaslServerCallbackHandler
    implements CallbackHandler {
        private static final String USER_PREFIX = "user_";
        private String userName;
        private final Map<String, String> credentials = new HashMap<String, String>();

        public SaslServerCallbackHandler(Configuration configuration, ServerConfiguration serverConfiguration) throws IOException {
            String configurationEntry = serverConfiguration.getString("saslJaasBookieSectionName", "Bookie");
            AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(configurationEntry);
            if (configurationEntries == null) {
                String errorMessage = "Could not find a '" + configurationEntry + "' entry in this configuration: Server cannot start.";
                throw new IOException(errorMessage);
            }
            this.credentials.clear();
            for (AppConfigurationEntry entry : configurationEntries) {
                Map<String, ?> options = entry.getOptions();
                for (Map.Entry<String, ?> pair : options.entrySet()) {
                    String key = pair.getKey();
                    if (!key.startsWith(USER_PREFIX)) continue;
                    String userName = key.substring(USER_PREFIX.length());
                    this.credentials.put(userName, (String)pair.getValue());
                }
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    this.handleNameCallback((NameCallback)callback);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    this.handlePasswordCallback((PasswordCallback)callback);
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    this.handleRealmCallback((RealmCallback)callback);
                    continue;
                }
                if (!(callback instanceof AuthorizeCallback)) continue;
                this.handleAuthorizeCallback((AuthorizeCallback)callback);
            }
        }

        private void handleNameCallback(NameCallback nc) {
            if (this.credentials.get(nc.getDefaultName()) == null) {
                LOG.error("User '" + nc.getDefaultName() + "' not found in list of JAAS DIGEST-MD5 users.");
                return;
            }
            nc.setName(nc.getDefaultName());
            this.userName = nc.getDefaultName();
        }

        private void handlePasswordCallback(PasswordCallback pc) {
            if (this.credentials.containsKey(this.userName)) {
                pc.setPassword(this.credentials.get(this.userName).toCharArray());
            } else {
                LOG.info("No password found for user: " + this.userName);
            }
        }

        private void handleRealmCallback(RealmCallback rc) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("client supplied realm: " + rc.getDefaultText());
            }
            rc.setText(rc.getDefaultText());
        }

        private void handleAuthorizeCallback(AuthorizeCallback ac) {
            String authorizationID;
            String authenticationID = ac.getAuthenticationID();
            if (!authenticationID.equals(authorizationID = ac.getAuthorizationID())) {
                ac.setAuthorized(false);
                LOG.info("Forbidden access to client: authenticationID=" + authenticationID + " is different from authorizationID=" + authorizationID + ".");
                return;
            }
            if (!SaslServerState.this.allowedIdsPattern.matcher(authenticationID).matches()) {
                ac.setAuthorized(false);
                LOG.info("Forbidden access to client: authenticationID=" + authenticationID + " is not allowed (see " + "saslJaasClientAllowedIds" + " property)");
                return;
            }
            ac.setAuthorized(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully authenticated client: authenticationID=" + authenticationID + ";  authorizationID=" + authorizationID + ".");
            }
            KerberosName kerberosName = new KerberosName(authenticationID);
            try {
                StringBuilder userNameBuilder = new StringBuilder(kerberosName.getShortName());
                userNameBuilder.append("/").append(kerberosName.getHostName());
                userNameBuilder.append("@").append(kerberosName.getRealm());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting authorizedID: " + userNameBuilder);
                }
                ac.setAuthorizedID(userNameBuilder.toString());
            }
            catch (IOException e) {
                LOG.error("Failed to set name based on Kerberos authentication rules.");
            }
        }
    }
}

