/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib;

import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.kv.KVAsyncStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.kv.KVStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.kv.RocksdbKVAsyncStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.kv.RocksdbKVStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCStores;
import org.apache.pulsar.functions.runtime.shaded.org.apache.distributedlog.api.namespace.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class StateStores {
    private static final Logger log = LoggerFactory.getLogger(StateStores.class);

    public static <K, V> Supplier<KVStore<K, V>> kvStoreSupplier() {
        return () -> new RocksdbKVStore();
    }

    public static <K, V> Supplier<KVAsyncStore<K, V>> kvAsyncStoreSupplier(Supplier<Namespace> logNamespaceSupplier) {
        return () -> new RocksdbKVAsyncStore(() -> new RocksdbKVStore(), logNamespaceSupplier);
    }

    public static Supplier<MVCCAsyncStore<byte[], byte[]>> mvccKvBytesStoreSupplier(Supplier<Namespace> nsSupplier) {
        return MVCCStores.bytesStoreSupplier(nsSupplier);
    }

    private StateStores() {
    }
}

