/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.kv;

import java.util.Collections;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.statestore.kv.Command;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.statestore.kv.DeleteRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.statestore.kv.PutRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.journal.CommandProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.kv.KVUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.kv.RocksdbKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KVCommandProcessor
implements CommandProcessor<RocksdbKVStore<byte[], byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(KVCommandProcessor.class);

    public static KVCommandProcessor of() {
        return new KVCommandProcessor();
    }

    @Override
    public void applyCommand(long revision, ByteBuf cmdBuf, RocksdbKVStore<byte[], byte[]> store) {
        Command command;
        try {
            command = KVUtils.newCommand(cmdBuf);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Invalid kv command found : buffer = {}, txid = {}", (Object)cmdBuf, (Object)revision);
            return;
        }
        switch (command.getReqCase()) {
            case NOP_REQ: {
                break;
            }
            case PUT_IF_ABSENT_REQ: {
                this.applyPutIfAbsentCommand(revision, command, store);
                return;
            }
            case PUT_REQ: {
                this.applyPutCommand(revision, command, store);
                return;
            }
            case DEL_REQ: {
                this.applyDeleteCommand(revision, command, store);
                return;
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPutCommand(long revision, Command command, RocksdbKVStore<byte[], byte[]> store) {
        PutRequest putReq = command.getPutReq();
        byte[] keyBytes = putReq.getKey().toByteArray();
        byte[] valBytes = putReq.getValue().toByteArray();
        ByteBuf serializedValBuf = KVUtils.serialize(valBytes, revision);
        try {
            byte[] serializedValBytes = ByteBufUtil.getBytes(serializedValBuf);
            store.put(keyBytes, serializedValBytes, revision);
        }
        finally {
            if (Collections.singletonList(serializedValBuf).get(0) != null) {
                serializedValBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPutIfAbsentCommand(long revision, Command command, RocksdbKVStore<byte[], byte[]> store) {
        PutRequest putReq = command.getPutReq();
        byte[] keyBytes = putReq.getKey().toByteArray();
        byte[] valBytes = putReq.getValue().toByteArray();
        ByteBuf serializedValBuf = KVUtils.serialize(valBytes, revision);
        try {
            byte[] serializedValBytes = ByteBufUtil.getBytes(serializedValBuf);
            store.putIfAbsent(keyBytes, serializedValBytes, revision);
        }
        finally {
            if (Collections.singletonList(serializedValBuf).get(0) != null) {
                serializedValBuf.release();
            }
        }
    }

    private void applyDeleteCommand(long revision, Command command, RocksdbKVStore<byte[], byte[]> store) {
        DeleteRequest delReq = command.getDelReq();
        byte[] keyBytes = delReq.getKey().toByteArray();
        store.delete(keyBytes, revision);
    }

    private KVCommandProcessor() {
    }
}

