/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.exceptions.InvalidStateStoreException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.journal.AbstractStateStoreWithJournal;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.journal.CommandProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCCommandProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCStoreImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.store.Command;
import org.apache.pulsar.functions.runtime.shaded.org.apache.distributedlog.api.namespace.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MVCCAsyncBytesStoreImpl
extends AbstractStateStoreWithJournal<MVCCStoreImpl<byte[], byte[]>>
implements MVCCAsyncStore<byte[], byte[]> {
    private static final Logger log = LoggerFactory.getLogger(MVCCAsyncBytesStoreImpl.class);

    MVCCAsyncBytesStoreImpl(Supplier<MVCCStoreImpl<byte[], byte[]>> storeSupplier, Supplier<Namespace> namespaceSupplier) {
        super(storeSupplier, namespaceSupplier);
    }

    @Override
    protected ByteBuf newCatchupMarker() {
        return MVCCUtils.newLogRecordBuf(MVCCUtils.NOP_CMD);
    }

    @Override
    protected CommandProcessor<MVCCStoreImpl<byte[], byte[]>> newCommandProcessor() {
        return MVCCCommandProcessor.of();
    }

    @Override
    @VisibleForTesting
    public boolean ownWriteScheduler() {
        return super.ownWriteScheduler();
    }

    @Override
    @VisibleForTesting
    public boolean ownReadScheduler() {
        return super.ownReadScheduler();
    }

    @Override
    public OpFactory<byte[], byte[]> getOpFactory() {
        return ((MVCCStoreImpl)this.localStore).getOpFactory();
    }

    private CompletableFuture<Long> writeCommandReturnTxId(Command command) {
        ByteBuf recordBuf = MVCCUtils.newLogRecordBuf(command);
        return this.writeCommandBufReturnTxId(recordBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<RangeResult<byte[], byte[]>> range(RangeOp<byte[], byte[]> rangeOp) {
        MVCCAsyncBytesStoreImpl mVCCAsyncBytesStoreImpl = this;
        synchronized (mVCCAsyncBytesStoreImpl) {
            if (!this.isInitialized) {
                return FutureUtils.exception(new InvalidStateStoreException("State store is not initialized yet."));
            }
        }
        return this.executeReadIO(() -> ((MVCCStoreImpl)this.localStore).range(rangeOp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PutResult<byte[], byte[]>> put(PutOp<byte[], byte[]> op) {
        MVCCAsyncBytesStoreImpl mVCCAsyncBytesStoreImpl = this;
        synchronized (mVCCAsyncBytesStoreImpl) {
            if (!this.isInitialized) {
                return FutureUtils.exception(new InvalidStateStoreException("State store is not initialized yet."));
            }
        }
        Command command = MVCCUtils.toCommand(op);
        return this.writeCommandReturnTxId(command).thenApplyAsync(revision -> ((MVCCStoreImpl)this.localStore).put((long)revision, op), (Executor)this.writeIOScheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<DeleteResult<byte[], byte[]>> delete(DeleteOp<byte[], byte[]> op) {
        MVCCAsyncBytesStoreImpl mVCCAsyncBytesStoreImpl = this;
        synchronized (mVCCAsyncBytesStoreImpl) {
            if (!this.isInitialized) {
                return FutureUtils.exception(new InvalidStateStoreException("State store is not initialized yet."));
            }
        }
        Command command = MVCCUtils.toCommand(op);
        return this.writeCommandReturnTxId(command).thenApplyAsync(revision -> ((MVCCStoreImpl)this.localStore).delete((long)revision, op), (Executor)this.writeIOScheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<TxnResult<byte[], byte[]>> txn(TxnOp<byte[], byte[]> op) {
        MVCCAsyncBytesStoreImpl mVCCAsyncBytesStoreImpl = this;
        synchronized (mVCCAsyncBytesStoreImpl) {
            if (!this.isInitialized) {
                return FutureUtils.exception(new InvalidStateStoreException("State store is not initialized yet."));
            }
        }
        Command command = MVCCUtils.toCommand(op);
        return this.writeCommandReturnTxId(command).thenApplyAsync(revision -> ((MVCCStoreImpl)this.localStore).txn((long)revision, op), (Executor)this.writeIOScheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<IncrementResult<byte[], byte[]>> increment(IncrementOp<byte[], byte[]> op) {
        MVCCAsyncBytesStoreImpl mVCCAsyncBytesStoreImpl = this;
        synchronized (mVCCAsyncBytesStoreImpl) {
            if (!this.isInitialized) {
                return FutureUtils.exception(new InvalidStateStoreException("State store is not initialized yet."));
            }
        }
        Command command = MVCCUtils.toCommand(op);
        return this.writeCommandReturnTxId(command).thenApplyAsync(revision -> ((MVCCStoreImpl)this.localStore).increment((long)revision, op), (Executor)this.writeIOScheduler);
    }
}

