/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufOutputStream;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareTarget;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.Op;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Code;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.exceptions.MVCCStoreException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.exceptions.StateStoreRuntimeException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.Constants;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoDeleteOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoPutOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoRangeOpImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RequestOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.store.Command;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.store.NopRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MVCCUtils {
    private static final Logger log = LoggerFactory.getLogger(MVCCUtils.class);
    public static final Command NOP_CMD = Command.newBuilder().setNopReq(NopRequest.newBuilder().build()).build();

    static PutRequest toPutRequest(PutOp<byte[], byte[]> op) {
        PutRequest.Builder reqBuilder = PutRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap(op.key())).setValue(UnsafeByteOperations.unsafeWrap(op.value())).setLease(0L).setPrevKv(op.option().prevKv());
        return reqBuilder.build();
    }

    static DeleteRangeRequest toDeleteRequest(DeleteOp<byte[], byte[]> op) {
        byte[] endKey;
        byte[] key = op.key();
        if (null == key) {
            key = Constants.NULL_START_KEY;
        }
        if (null == (endKey = op.option().endKey())) {
            endKey = Constants.NULL_END_KEY;
        }
        DeleteRangeRequest.Builder reqBuilder = DeleteRangeRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap(key)).setRangeEnd(UnsafeByteOperations.unsafeWrap(endKey));
        return reqBuilder.setPrevKv(op.option().prevKv()).build();
    }

    static RangeRequest toRangeRequest(RangeOp<byte[], byte[]> op) {
        byte[] endKey;
        byte[] key = op.key();
        if (null == key) {
            key = Constants.NULL_START_KEY;
        }
        if (null == (endKey = op.option().endKey())) {
            endKey = Constants.NULL_END_KEY;
        }
        RangeRequest.Builder reqBuilder = RangeRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap(key)).setRangeEnd(UnsafeByteOperations.unsafeWrap(endKey)).setMaxCreateRevision(op.option().maxCreateRev()).setMinCreateRevision(op.option().minCreateRev()).setMaxModRevision(op.option().maxModRev()).setMinModRevision(op.option().minModRev()).setCountOnly(false);
        return reqBuilder.build();
    }

    private static List<RequestOp> toRequestOpList(List<Op<byte[], byte[]>> ops) {
        if (ops == null) {
            return Collections.emptyList();
        }
        ArrayList<RequestOp> requestOps = Lists.newArrayListWithExpectedSize(ops.size());
        block5: for (Op<byte[], byte[]> op : ops) {
            switch (op.type()) {
                case PUT: {
                    requestOps.add(RequestOp.newBuilder().setRequestPut(MVCCUtils.toPutRequest((PutOp)op)).build());
                    continue block5;
                }
                case DELETE: {
                    requestOps.add(RequestOp.newBuilder().setRequestDeleteRange(MVCCUtils.toDeleteRequest((DeleteOp)op)).build());
                    continue block5;
                }
                case RANGE: {
                    requestOps.add(RequestOp.newBuilder().setRequestRange(MVCCUtils.toRangeRequest((RangeOp)op)).build());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown request " + (Object)((Object)op.type()) + " found in a txn request");
        }
        return requestOps;
    }

    public static Op<byte[], byte[]> toApiOp(RequestOp protoOp) {
        switch (protoOp.getRequestCase()) {
            case REQUEST_PUT: {
                return ProtoPutOpImpl.newPutOp(protoOp.getRequestPut());
            }
            case REQUEST_RANGE: {
                return ProtoRangeOpImpl.newRangeOp(protoOp.getRequestRange());
            }
            case REQUEST_DELETE_RANGE: {
                return ProtoDeleteOpImpl.newDeleteOp(protoOp.getRequestDeleteRange());
            }
        }
        throw new IllegalArgumentException("Unknown request " + protoOp.getRequestCase() + " found in a txn request");
    }

    private static List<Compare> toCompareList(List<CompareOp<byte[], byte[]>> ops) {
        ArrayList<Compare> compares = Lists.newArrayListWithExpectedSize(ops.size());
        for (CompareOp<byte[], byte[]> op : ops) {
            compares.add(MVCCUtils.toCompare(op));
        }
        return compares;
    }

    private static Compare toCompare(CompareOp<byte[], byte[]> op) {
        Compare.Builder compareBuilder = Compare.newBuilder();
        compareBuilder.setTarget(MVCCUtils.toProtoCompareTarget(op.target()));
        compareBuilder.setResult(MVCCUtils.toProtoCompareResult(op.result()));
        compareBuilder.setKey(UnsafeByteOperations.unsafeWrap(op.key()));
        switch (op.target()) {
            case MOD: {
                compareBuilder.setModRevision(op.revision());
                break;
            }
            case CREATE: {
                compareBuilder.setCreateRevision(op.revision());
                break;
            }
            case VERSION: {
                compareBuilder.setVersion(op.revision());
                break;
            }
            case VALUE: {
                if (op.value() == null) break;
                compareBuilder.setValue(UnsafeByteOperations.unsafeWrap(op.value()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid compare target " + (Object)((Object)op.target()));
            }
        }
        return compareBuilder.build();
    }

    private static Compare.CompareTarget toProtoCompareTarget(CompareTarget target) {
        switch (target) {
            case MOD: {
                return Compare.CompareTarget.MOD;
            }
            case CREATE: {
                return Compare.CompareTarget.CREATE;
            }
            case VERSION: {
                return Compare.CompareTarget.VERSION;
            }
            case VALUE: {
                return Compare.CompareTarget.VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid compare target " + (Object)((Object)target));
    }

    public static CompareTarget toApiCompareTarget(Compare.CompareTarget target) {
        switch (target) {
            case MOD: {
                return CompareTarget.MOD;
            }
            case CREATE: {
                return CompareTarget.CREATE;
            }
            case VERSION: {
                return CompareTarget.VERSION;
            }
            case VALUE: {
                return CompareTarget.VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid proto compare target " + target);
    }

    private static Compare.CompareResult toProtoCompareResult(CompareResult result) {
        switch (result) {
            case LESS: {
                return Compare.CompareResult.LESS;
            }
            case EQUAL: {
                return Compare.CompareResult.EQUAL;
            }
            case GREATER: {
                return Compare.CompareResult.GREATER;
            }
            case NOT_EQUAL: {
                return Compare.CompareResult.NOT_EQUAL;
            }
        }
        throw new IllegalArgumentException("Invalid compare result " + (Object)((Object)result));
    }

    public static CompareResult toApiCompareResult(Compare.CompareResult result) {
        switch (result) {
            case LESS: {
                return CompareResult.LESS;
            }
            case EQUAL: {
                return CompareResult.EQUAL;
            }
            case GREATER: {
                return CompareResult.GREATER;
            }
            case NOT_EQUAL: {
                return CompareResult.NOT_EQUAL;
            }
        }
        throw new IllegalArgumentException("Invalid proto compare result " + result);
    }

    static TxnRequest toTxnRequest(TxnOp<byte[], byte[]> op) {
        return TxnRequest.newBuilder().addAllSuccess(MVCCUtils.toRequestOpList(op.successOps())).addAllFailure(MVCCUtils.toRequestOpList(op.failureOps())).addAllCompare(MVCCUtils.toCompareList(op.compareOps())).build();
    }

    static IncrementRequest toIncrementRequest(IncrementOp<byte[], byte[]> op) {
        return IncrementRequest.newBuilder().setKey(UnsafeByteOperations.unsafeWrap(op.key())).setAmount(op.amount()).setGetTotal(op.option().getTotal()).build();
    }

    static Command toCommand(Op<byte[], byte[]> op) {
        Command.Builder cmdBuilder = Command.newBuilder();
        switch (op.type()) {
            case PUT: {
                cmdBuilder.setPutReq(MVCCUtils.toPutRequest((PutOp)op));
                break;
            }
            case DELETE: {
                cmdBuilder.setDeleteReq(MVCCUtils.toDeleteRequest((DeleteOp)op));
                break;
            }
            case TXN: {
                cmdBuilder.setTxnReq(MVCCUtils.toTxnRequest((TxnOp)op));
                break;
            }
            case INCREMENT: {
                cmdBuilder.setIncrReq(MVCCUtils.toIncrementRequest((IncrementOp)op));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command type " + (Object)((Object)op.type()));
            }
        }
        return cmdBuilder.build();
    }

    public static ByteBuf newLogRecordBuf(Command command) {
        ByteBuf buf = Unpooled.buffer(command.getSerializedSize());
        try {
            command.writeTo(new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            throw new StateStoreRuntimeException("Invalid command : " + command, e);
        }
        return buf;
    }

    static Command newCommand(ByteBuf recordBuf) {
        try {
            return Command.parseFrom(recordBuf.nioBuffer());
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Found a corrupted record on replaying log stream", (Throwable)e);
            throw new StateStoreRuntimeException("Found a corrupted record on replaying log stream", e);
        }
    }

    public static <T> CompletableFuture<T> failWithCode(Code code, String msg) {
        return FutureUtils.exception(new MVCCStoreException(code, msg));
    }

    private MVCCUtils() {
    }
}

