/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto;

import java.util.Arrays;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.store.Command;

public class ProtoPutOpImpl
implements PutOp<byte[], byte[]>,
PutOption<byte[]> {
    private static final Recycler<ProtoPutOpImpl> RECYCLER = new Recycler<ProtoPutOpImpl>(){

        @Override
        protected ProtoPutOpImpl newObject(Recycler.Handle<ProtoPutOpImpl> handle) {
            return new ProtoPutOpImpl(handle);
        }
    };
    private final Recycler.Handle<ProtoPutOpImpl> recyclerHandle;
    private PutRequest req;
    private byte[] key;
    private byte[] value;
    private long revision;

    public static ProtoPutOpImpl newPutOp(Command command) {
        ProtoPutOpImpl op = RECYCLER.get();
        op.setCommand(command);
        return op;
    }

    public static ProtoPutOpImpl newPutOp(PutRequest req) {
        ProtoPutOpImpl op = RECYCLER.get();
        op.setPutRequest(req);
        return op;
    }

    @Override
    public byte[] value() {
        if (null != this.value) {
            return this.value;
        }
        this.value = this.req.getValue().toByteArray();
        return this.value;
    }

    @Override
    public PutOption<byte[]> option() {
        return this;
    }

    public void setCommand(Command command) {
        this.req = command.getPutReq();
    }

    public void setPutRequest(PutRequest request) {
        this.req = request;
    }

    @Override
    public boolean prevKv() {
        return this.req.getPrevKv();
    }

    @Override
    public OpType type() {
        return OpType.PUT;
    }

    @Override
    public byte[] key() {
        if (null != this.key) {
            return this.key;
        }
        this.key = this.req.getKey().toByteArray();
        return this.key;
    }

    void reset() {
        this.req = null;
        this.key = null;
        this.value = null;
        this.revision = -1L;
    }

    @Override
    public void close() {
        this.reset();
        this.recyclerHandle.recycle(this);
    }

    public ProtoPutOpImpl(Recycler.Handle<ProtoPutOpImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public String toString() {
        return "ProtoPutOpImpl(req=" + this.req + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ", revision=" + this.revision + ")";
    }
}

