/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto;

import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.Op;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.collections.RecyclableArrayList;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.MVCCUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.impl.mvcc.op.proto.ProtoCompareImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RequestOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;

public class ProtoTxnOpImpl
implements TxnOp<byte[], byte[]> {
    private static final Recycler<ProtoTxnOpImpl> RECYCLER = new Recycler<ProtoTxnOpImpl>(){

        @Override
        protected ProtoTxnOpImpl newObject(Recycler.Handle<ProtoTxnOpImpl> handle) {
            return new ProtoTxnOpImpl(handle);
        }
    };
    private static final RecyclableArrayList.Recycler<CompareOp<byte[], byte[]>> COMPARE_OPS_RECYCLER = new RecyclableArrayList.Recycler();
    private static final RecyclableArrayList.Recycler<Op<byte[], byte[]>> OPS_RECYCLER = new RecyclableArrayList.Recycler();
    private final Recycler.Handle<ProtoTxnOpImpl> recyclerHandle;
    private TxnRequest request;
    private RecyclableArrayList<CompareOp<byte[], byte[]>> compareOps;
    private RecyclableArrayList<Op<byte[], byte[]>> successOps;
    private RecyclableArrayList<Op<byte[], byte[]>> failureOps;

    public static ProtoTxnOpImpl newTxnOp(TxnRequest request) {
        ProtoTxnOpImpl op = RECYCLER.get();
        op.setRequest(request);
        RecyclableArrayList<CompareOp<byte[], byte[]>> compareOps = COMPARE_OPS_RECYCLER.newInstance();
        for (Compare compare : request.getCompareList()) {
            compareOps.add(ProtoCompareImpl.newCompareOp(compare));
        }
        op.setCompareOps(compareOps);
        RecyclableArrayList<Op<byte[], byte[]>> successOps = OPS_RECYCLER.newInstance();
        for (RequestOp reqOp : request.getSuccessList()) {
            successOps.add(MVCCUtils.toApiOp(reqOp));
        }
        op.setSuccessOps(successOps);
        RecyclableArrayList<Op<byte[], byte[]>> recyclableArrayList = OPS_RECYCLER.newInstance();
        for (RequestOp reqOp : request.getFailureList()) {
            recyclableArrayList.add(MVCCUtils.toApiOp(reqOp));
        }
        return op;
    }

    private void reset() {
        this.request = null;
        if (null != this.compareOps) {
            this.compareOps.forEach(CompareOp::close);
            this.compareOps.recycle();
        }
        if (null != this.successOps) {
            this.successOps.forEach(Op::close);
            this.successOps.recycle();
        }
        if (null != this.failureOps) {
            this.failureOps.forEach(Op::close);
            this.failureOps.recycle();
        }
    }

    @Override
    public List<CompareOp<byte[], byte[]>> compareOps() {
        return this.compareOps;
    }

    @Override
    public List<Op<byte[], byte[]>> successOps() {
        return this.successOps;
    }

    @Override
    public List<Op<byte[], byte[]>> failureOps() {
        return this.failureOps;
    }

    @Override
    public OpType type() {
        return OpType.TXN;
    }

    @Override
    public void close() {
        this.reset();
        this.recyclerHandle.recycle(this);
    }

    public ProtoTxnOpImpl(Recycler.Handle<ProtoTxnOpImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public String toString() {
        return "ProtoTxnOpImpl(request=" + this.request + ", compareOps=" + this.compareOps + ", successOps=" + this.successOps + ", failureOps=" + this.failureOps + ")";
    }

    private void setRequest(TxnRequest request) {
        this.request = request;
    }

    private void setCompareOps(RecyclableArrayList<CompareOp<byte[], byte[]>> compareOps) {
        this.compareOps = compareOps;
    }

    private void setSuccessOps(RecyclableArrayList<Op<byte[], byte[]>> successOps) {
        this.successOps = successOps;
    }

    private void setFailureOps(RecyclableArrayList<Op<byte[], byte[]>> failureOps) {
        this.failureOps = failureOps;
    }
}

