/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.grpc;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.stub.StreamObserver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.ResponseHeader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TableServiceGrpc;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.metadata.RangeStoreService;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.grpc.handler.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcTableService
extends TableServiceGrpc.TableServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcTableService.class);
    private final RangeStoreService rangeStore;

    public GrpcTableService(RangeStoreService store) {
        this.rangeStore = store;
        log.info("Created Table service");
    }

    @Override
    public void range(final RangeRequest request, StreamObserver<RangeResponse> responseObserver) {
        this.rangeStore.range(request).whenComplete(new ResponseHandler<RangeResponse>(responseObserver){

            @Override
            protected RangeResponse createErrorResp(Throwable cause) {
                return RangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).setRoutingHeader(request.getHeader()).build()).build();
            }
        });
    }

    @Override
    public void put(final PutRequest request, StreamObserver<PutResponse> responseObserver) {
        this.rangeStore.put(request).whenComplete(new ResponseHandler<PutResponse>(responseObserver){

            @Override
            protected PutResponse createErrorResp(Throwable cause) {
                return PutResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).setRoutingHeader(request.getHeader()).build()).build();
            }
        });
    }

    @Override
    public void delete(final DeleteRangeRequest request, StreamObserver<DeleteRangeResponse> responseObserver) {
        this.rangeStore.delete(request).whenComplete(new ResponseHandler<DeleteRangeResponse>(responseObserver){

            @Override
            protected DeleteRangeResponse createErrorResp(Throwable cause) {
                return DeleteRangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).setRoutingHeader(request.getHeader()).build()).build();
            }
        });
    }

    @Override
    public void txn(final TxnRequest request, StreamObserver<TxnResponse> responseObserver) {
        this.rangeStore.txn(request).whenComplete(new ResponseHandler<TxnResponse>(responseObserver){

            @Override
            protected TxnResponse createErrorResp(Throwable cause) {
                return TxnResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).setRoutingHeader(request.getHeader()).build()).build();
            }
        });
    }

    @Override
    public void increment(final IncrementRequest request, StreamObserver<IncrementResponse> responseObserver) {
        this.rangeStore.incr(request).whenComplete(new ResponseHandler<IncrementResponse>(responseObserver){

            @Override
            protected IncrementResponse createErrorResp(Throwable cause) {
                return IncrementResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.INTERNAL_SERVER_ERROR).setRoutingHeader(request.getHeader()).build()).build();
            }
        });
    }
}

