/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.kv;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Maps;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.protocol.RangeId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.api.kv.TableStore;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.kv.TableStoreFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.kv.TableStoreImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;

public class TableStoreCache {
    private final MVCCStoreFactory mvccStoreFactory;
    private final TableStoreFactory tableStoreFactory;
    private final ConcurrentMap<RangeId, TableStore> tableStores;
    private final ConcurrentMap<RangeId, CompletableFuture<TableStore>> tableStoresOpening;

    public TableStoreCache(MVCCStoreFactory mvccStoreFactory) {
        this(mvccStoreFactory, store -> new TableStoreImpl(store));
    }

    public TableStoreCache(MVCCStoreFactory mvccStoreFactory, TableStoreFactory tableStoreFactory) {
        this.mvccStoreFactory = mvccStoreFactory;
        this.tableStoreFactory = tableStoreFactory;
        this.tableStores = Maps.newConcurrentMap();
        this.tableStoresOpening = Maps.newConcurrentMap();
    }

    @VisibleForTesting
    public ConcurrentMap<RangeId, TableStore> getTableStores() {
        return this.tableStores;
    }

    @VisibleForTesting
    ConcurrentMap<RangeId, CompletableFuture<TableStore>> getTableStoresOpening() {
        return this.tableStoresOpening;
    }

    public TableStore getTableStore(RangeId rid) {
        return (TableStore)this.tableStores.get(rid);
    }

    public CompletableFuture<TableStore> openTableStore(long scId, RangeId rid) {
        TableStore store = (TableStore)this.tableStores.get(rid);
        if (null != store) {
            return FutureUtils.value(store);
        }
        CompletableFuture<TableStore> openFuture = (CompletableFuture<TableStore>)this.tableStoresOpening.get(rid);
        if (null != openFuture) {
            return openFuture;
        }
        openFuture = FutureUtils.createFuture();
        CompletableFuture<TableStore> existingOpenFuture = this.tableStoresOpening.putIfAbsent(rid, openFuture);
        if (null != existingOpenFuture) {
            return existingOpenFuture;
        }
        CompletableFuture<TableStore> openingFuture = openFuture;
        ((CompletableFuture)this.mvccStoreFactory.openStore(scId, rid.getStreamId(), rid.getRangeId()).thenAccept(mvccStore -> {
            TableStore newStore = this.tableStoreFactory.createStore((MVCCAsyncStore<byte[], byte[]>)mvccStore);
            TableStore oldStore = this.tableStores.putIfAbsent(rid, newStore);
            if (null != oldStore) {
                openingFuture.complete(oldStore);
            } else {
                openingFuture.complete(newStore);
            }
            this.tableStoresOpening.remove(rid, openingFuture);
        })).exceptionally(cause -> {
            openingFuture.completeExceptionally((Throwable)cause);
            this.tableStoresOpening.remove(rid, openingFuture);
            return null;
        });
        return openingFuture;
    }
}

