/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.bookie;

import java.util.Formatter;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.EntryFormatter;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util.LedgerIdFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FormatUtil.class);

    public static void formatEntry(long pos, ByteBuf recBuff, boolean printMsg, LedgerIdFormatter ledgerIdFormatter, EntryFormatter entryFormatter) {
        int entrySize = recBuff.readableBytes();
        long ledgerId = recBuff.readLong();
        long entryId = recBuff.readLong();
        LOG.info("--------- Lid=" + ledgerIdFormatter.formatLedgerId(ledgerId) + ", Eid=" + entryId + ", ByteOffset=" + pos + ", EntrySize=" + entrySize + " ---------");
        if (entryId == -4096L) {
            int masterKeyLen = recBuff.readInt();
            byte[] masterKey = new byte[masterKeyLen];
            recBuff.readBytes(masterKey);
            LOG.info("Type:           META");
            LOG.info("MasterKey:      " + FormatUtil.bytes2Hex(masterKey));
            LOG.info("");
            return;
        }
        if (entryId == -8192L) {
            LOG.info("Type:           META");
            LOG.info("Fenced");
            LOG.info("");
            return;
        }
        long lastAddConfirmed = recBuff.readLong();
        LOG.info("Type:           DATA");
        LOG.info("LastConfirmed:  " + lastAddConfirmed);
        if (!printMsg) {
            LOG.info("");
            return;
        }
        recBuff.skipBytes(8);
        LOG.info("Data:");
        LOG.info("");
        try {
            byte[] ret = new byte[recBuff.readableBytes()];
            recBuff.readBytes(ret);
            entryFormatter.formatEntry(ret);
        }
        catch (Exception e) {
            LOG.info("N/A. Corrupted.");
        }
        LOG.info("");
    }

    public static String bytes2Hex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : data) {
            formatter.format("%02x", b);
        }
        formatter.close();
        return sb.toString();
    }
}

