/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.functions.runtime.shaded.org.apache.jute.BinaryInputArchive;
import org.apache.pulsar.functions.runtime.shaded.org.apache.jute.InputArchive;
import org.apache.pulsar.functions.runtime.shaded.org.apache.jute.OutputArchive;
import org.apache.pulsar.functions.runtime.shaded.org.apache.jute.Record;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.DataTree;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.Request;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.TxnLogEntry;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.ZooTrace;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.server.persistence.Util;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CloseSessionTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateContainerTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateTTLTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.CreateTxnV0;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.DeleteTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.ErrorTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.MultiTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.SetACLTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.SetDataTxn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.TxnDigest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);

    public static TxnLogEntry deserializeTxn(byte[] txnBytes) throws IOException {
        TxnHeader hdr = new TxnHeader();
        ByteArrayInputStream bais = new ByteArrayInputStream(txnBytes);
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        hdr.deserialize(ia, "hdr");
        bais.mark(bais.available());
        Record txn = null;
        switch (hdr.getType()) {
            case -10: {
                txn = new CreateSessionTxn();
                break;
            }
            case -11: {
                txn = ZooKeeperServer.isCloseSessionTxnEnabled() ? new CloseSessionTxn() : null;
                break;
            }
            case 1: 
            case 15: {
                txn = new CreateTxn();
                break;
            }
            case 21: {
                txn = new CreateTTLTxn();
                break;
            }
            case 19: {
                txn = new CreateContainerTxn();
                break;
            }
            case 2: 
            case 20: {
                txn = new DeleteTxn();
                break;
            }
            case 5: 
            case 16: {
                txn = new SetDataTxn();
                break;
            }
            case 7: {
                txn = new SetACLTxn();
                break;
            }
            case -1: {
                txn = new ErrorTxn();
                break;
            }
            case 14: {
                txn = new MultiTxn();
                break;
            }
            default: {
                throw new IOException("Unsupported Txn with type=%d" + hdr.getType());
            }
        }
        if (txn != null) {
            try {
                txn.deserialize(ia, "txn");
            }
            catch (EOFException e) {
                if (hdr.getType() == 1) {
                    CreateTxn create = (CreateTxn)txn;
                    bais.reset();
                    CreateTxnV0 createv0 = new CreateTxnV0();
                    createv0.deserialize(ia, "txn");
                    create.setPath(createv0.getPath());
                    create.setData(createv0.getData());
                    create.setAcl(createv0.getAcl());
                    create.setEphemeral(createv0.getEphemeral());
                    create.setParentCVersion(-1);
                }
                if (hdr.getType() == -11) {
                    txn = null;
                }
                throw e;
            }
        }
        TxnDigest digest = null;
        if (ZooKeeperServer.isDigestEnabled()) {
            digest = new TxnDigest();
            try {
                digest.deserialize(ia, "digest");
            }
            catch (EOFException exception) {
                digest = null;
            }
        }
        return new TxnLogEntry(txn, hdr, digest);
    }

    public static void deserializeSnapshot(DataTree dt, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count = ia.readInt("count"); count > 0; --count) {
            long id = ia.readLong("id");
            int to = ia.readInt("timeout");
            sessions.put(id, to);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to);
        }
        dt.deserialize(ia, "tree");
    }

    public static void serializeSnapshot(DataTree dt, OutputArchive oa, Map<Long, Integer> sessions) throws IOException {
        HashMap<Long, Integer> sessSnap = new HashMap<Long, Integer>(sessions);
        oa.writeInt(sessSnap.size(), "count");
        for (Map.Entry<Long, Integer> entry : sessSnap.entrySet()) {
            oa.writeLong(entry.getKey(), "id");
            oa.writeInt(entry.getValue(), "timeout");
        }
        dt.serialize(oa, "tree");
    }

    public static byte[] serializeRequest(Request request) {
        if (request == null || request.getHdr() == null) {
            return null;
        }
        byte[] data = new byte[32];
        try {
            data = Util.marshallTxnEntry(request.getHdr(), request.getTxn(), request.getTxnDigest());
        }
        catch (IOException e) {
            LOG.error("This really should be impossible", (Throwable)e);
        }
        return data;
    }
}

