/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.rocksdb;

import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.ColumnFamilyDescriptor;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.ColumnFamilyHandle;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.DBOptions;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.Options;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RocksDB;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RocksDBException;

public class TtlDB
extends RocksDB {
    public static TtlDB open(Options options, String string) throws RocksDBException {
        return TtlDB.open(options, string, 0, false);
    }

    public static TtlDB open(Options options, String string, int n, boolean bl) throws RocksDBException {
        return new TtlDB(TtlDB.open(options.nativeHandle_, string, n, bl));
    }

    public static TtlDB open(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2, List<Integer> list3, boolean bl) throws RocksDBException {
        if (list.size() != list3.size()) {
            throw new IllegalArgumentException("There must be a ttl value per columnfamily handle.");
        }
        byte[][] byArrayArray = new byte[list.size()][];
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ColumnFamilyDescriptor columnFamilyDescriptor = list.get(i);
            byArrayArray[i] = columnFamilyDescriptor.getName();
            lArray[i] = columnFamilyDescriptor.getOptions().nativeHandle_;
        }
        int[] nArray = new int[list3.size()];
        for (int i = 0; i < list3.size(); ++i) {
            nArray[i] = list3.get(i);
        }
        long[] lArray2 = TtlDB.openCF(dBOptions.nativeHandle_, string, byArrayArray, lArray, nArray, bl);
        TtlDB ttlDB = new TtlDB(lArray2[0]);
        for (int i = 1; i < lArray2.length; ++i) {
            list2.add(new ColumnFamilyHandle(ttlDB, lArray2[i]));
        }
        return ttlDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeE() throws RocksDBException {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TtlDB.closeDatabase(this.nativeHandle_);
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.owningHandle_.compareAndSet(true, false)) {
            try {
                TtlDB.closeDatabase(this.nativeHandle_);
            }
            catch (RocksDBException rocksDBException) {
            }
            finally {
                this.disposeInternal();
            }
        }
    }

    public ColumnFamilyHandle createColumnFamilyWithTtl(ColumnFamilyDescriptor columnFamilyDescriptor, int n) throws RocksDBException {
        return new ColumnFamilyHandle(this, this.createColumnFamilyWithTtl(this.nativeHandle_, columnFamilyDescriptor.getName(), columnFamilyDescriptor.getOptions().nativeHandle_, n));
    }

    protected TtlDB(long l) {
        super(l);
    }

    @Override
    protected native void disposeInternal(long var1);

    private static native long open(long var0, String var2, int var3, boolean var4) throws RocksDBException;

    private static native long[] openCF(long var0, String var2, byte[][] var3, long[] var4, int[] var5, boolean var6) throws RocksDBException;

    private native long createColumnFamilyWithTtl(long var1, byte[] var3, long var4, int var6) throws RocksDBException;

    private static native void closeDatabase(long var0) throws RocksDBException;
}

