/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.io.File;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.functions.WindowConfig;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.util.ClassLoaderUtils;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.api.WindowFunction;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.functions.runtime.shaded.com.google.gson.Gson;
import org.apache.pulsar.functions.runtime.shaded.com.google.gson.reflect.TypeToken;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.functions.utils.CryptoUtils;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.ResourceConfigUtils;
import org.apache.pulsar.functions.utils.ValidatorUtils;
import org.apache.pulsar.functions.utils.WindowConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionConfigUtils.class);
    static final Integer MAX_PENDING_ASYNC_REQUESTS_DEFAULT = 1000;
    static final Boolean FORWARD_SOURCE_MESSAGE_PROPERTY_DEFAULT = Boolean.TRUE;
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.create();

    public static Function.FunctionDetails convert(FunctionConfig functionConfig, ClassLoader classLoader) throws IllegalArgumentException {
        WindowConfig windowConfig;
        boolean isBuiltin = !org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getJar()) && functionConfig.getJar().startsWith("builtin");
        Class<?>[] typeArgs = null;
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA && classLoader != null) {
            try {
                typeArgs = FunctionCommon.getFunctionTypes(functionConfig, classLoader);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new IllegalArgumentException(String.format("Function class %s must be in class path", functionConfig.getClassName()), e);
            }
        }
        Function.FunctionDetails.Builder functionDetailsBuilder = Function.FunctionDetails.newBuilder();
        Function.SourceSpec.Builder sourceSpecBuilder = Function.SourceSpec.newBuilder();
        if (functionConfig.getInputs() != null) {
            functionConfig.getInputs().forEach(topicName -> sourceSpecBuilder.putInputSpecs((String)topicName, Function.ConsumerSpec.newBuilder().setIsRegexPattern(false).build()));
        }
        if (functionConfig.getTopicsPattern() != null && !functionConfig.getTopicsPattern().isEmpty()) {
            sourceSpecBuilder.putInputSpecs(functionConfig.getTopicsPattern(), Function.ConsumerSpec.newBuilder().setIsRegexPattern(true).build());
        }
        if (functionConfig.getCustomSerdeInputs() != null) {
            functionConfig.getCustomSerdeInputs().forEach((topicName, serdeClassName) -> sourceSpecBuilder.putInputSpecs((String)topicName, Function.ConsumerSpec.newBuilder().setSerdeClassName((String)serdeClassName).setIsRegexPattern(false).build()));
        }
        if (functionConfig.getCustomSchemaInputs() != null) {
            functionConfig.getCustomSchemaInputs().forEach((topicName, conf) -> {
                try {
                    ConsumerConfig consumerConfig = OBJECT_MAPPER.readValue((String)conf, ConsumerConfig.class);
                    sourceSpecBuilder.putInputSpecs((String)topicName, Function.ConsumerSpec.newBuilder().setSchemaType(consumerConfig.getSchemaType()).putAllSchemaProperties(consumerConfig.getSchemaProperties()).putAllConsumerProperties(consumerConfig.getConsumerProperties()).setIsRegexPattern(false).build());
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException(String.format("Incorrect custom schema inputs ,Topic %s ", topicName));
                }
            });
        }
        if (functionConfig.getInputSpecs() != null) {
            functionConfig.getInputSpecs().forEach((topicName, consumerConf) -> {
                Function.ConsumerSpec.Builder bldr = Function.ConsumerSpec.newBuilder().setIsRegexPattern(consumerConf.isRegexPattern());
                if (StringUtils.isNotBlank(consumerConf.getSchemaType())) {
                    bldr.setSchemaType(consumerConf.getSchemaType());
                } else if (StringUtils.isNotBlank(consumerConf.getSerdeClassName())) {
                    bldr.setSerdeClassName(consumerConf.getSerdeClassName());
                }
                if (consumerConf.getReceiverQueueSize() != null) {
                    bldr.setReceiverQueueSize(Function.ConsumerSpec.ReceiverQueueSize.newBuilder().setValue(consumerConf.getReceiverQueueSize()).build());
                }
                if (consumerConf.getSchemaProperties() != null) {
                    bldr.putAllSchemaProperties(consumerConf.getSchemaProperties());
                }
                if (consumerConf.getCryptoConfig() != null) {
                    bldr.setCryptoSpec(CryptoUtils.convert(consumerConf.getCryptoConfig()));
                }
                bldr.putAllConsumerProperties(consumerConf.getConsumerProperties());
                bldr.setPoolMessages(consumerConf.isPoolMessages());
                sourceSpecBuilder.putInputSpecs((String)topicName, bldr.build());
            });
        }
        Function.SubscriptionType subType = functionConfig.getRetainOrdering() != null && functionConfig.getRetainOrdering() != false || FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE.equals((Object)functionConfig.getProcessingGuarantees()) ? Function.SubscriptionType.FAILOVER : (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering() != false ? Function.SubscriptionType.KEY_SHARED : Function.SubscriptionType.SHARED);
        sourceSpecBuilder.setSubscriptionType(subType);
        if (StringUtils.isNotBlank(functionConfig.getSubName())) {
            sourceSpecBuilder.setSubscriptionName(functionConfig.getSubName());
        }
        if (functionConfig.getSubscriptionPosition() != null) {
            Function.SubscriptionPosition subPosition = null;
            subPosition = SubscriptionInitialPosition.Earliest == functionConfig.getSubscriptionPosition() ? Function.SubscriptionPosition.EARLIEST : Function.SubscriptionPosition.LATEST;
            sourceSpecBuilder.setSubscriptionPosition(subPosition);
        }
        if (typeArgs != null) {
            sourceSpecBuilder.setTypeClassName(typeArgs[0].getName());
        }
        if (functionConfig.getTimeoutMs() != null) {
            sourceSpecBuilder.setTimeoutMs(functionConfig.getTimeoutMs());
            sourceSpecBuilder.setNegativeAckRedeliveryDelayMs(functionConfig.getTimeoutMs());
        }
        if (functionConfig.getCleanupSubscription() != null) {
            sourceSpecBuilder.setCleanupSubscription(functionConfig.getCleanupSubscription());
        } else {
            sourceSpecBuilder.setCleanupSubscription(true);
        }
        functionDetailsBuilder.setSource(sourceSpecBuilder);
        Function.SinkSpec.Builder sinkSpecBuilder = Function.SinkSpec.newBuilder();
        if (functionConfig.getOutput() != null) {
            sinkSpecBuilder.setTopic(functionConfig.getOutput());
        }
        if (!StringUtils.isBlank(functionConfig.getOutputSerdeClassName())) {
            sinkSpecBuilder.setSerDeClassName(functionConfig.getOutputSerdeClassName());
        }
        if (!StringUtils.isBlank(functionConfig.getOutputSchemaType())) {
            sinkSpecBuilder.setSchemaType(functionConfig.getOutputSchemaType());
        }
        if (functionConfig.getForwardSourceMessageProperty() == Boolean.TRUE) {
            sinkSpecBuilder.setForwardSourceMessageProperty(functionConfig.getForwardSourceMessageProperty());
        }
        if (functionConfig.getCustomSchemaOutputs() != null && functionConfig.getOutput() != null) {
            String conf2 = functionConfig.getCustomSchemaOutputs().get(functionConfig.getOutput());
            try {
                if (StringUtils.isNotEmpty(conf2)) {
                    ConsumerConfig consumerConfig = OBJECT_MAPPER.readValue(conf2, ConsumerConfig.class);
                    sinkSpecBuilder.putAllSchemaProperties(consumerConfig.getSchemaProperties());
                    sinkSpecBuilder.putAllConsumerProperties(consumerConfig.getConsumerProperties());
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(String.format("Incorrect custom schema outputs ,Topic %s ", functionConfig.getOutput()));
            }
        }
        if (typeArgs != null) {
            sinkSpecBuilder.setTypeClassName(typeArgs[1].getName());
        }
        if (functionConfig.getProducerConfig() != null) {
            ProducerConfig producerConf = functionConfig.getProducerConfig();
            Function.ProducerSpec.Builder pbldr = Function.ProducerSpec.newBuilder();
            if (producerConf.getMaxPendingMessages() != null) {
                pbldr.setMaxPendingMessages(producerConf.getMaxPendingMessages());
            }
            if (producerConf.getMaxPendingMessagesAcrossPartitions() != null) {
                pbldr.setMaxPendingMessagesAcrossPartitions(producerConf.getMaxPendingMessagesAcrossPartitions());
            }
            if (producerConf.getUseThreadLocalProducers() != null) {
                pbldr.setUseThreadLocalProducers(producerConf.getUseThreadLocalProducers());
            }
            if (producerConf.getCryptoConfig() != null) {
                pbldr.setCryptoSpec(CryptoUtils.convert(producerConf.getCryptoConfig()));
            }
            if (producerConf.getBatchBuilder() != null) {
                pbldr.setBatchBuilder(producerConf.getBatchBuilder());
            }
            sinkSpecBuilder.setProducerSpec(pbldr.build());
        }
        functionDetailsBuilder.setSink(sinkSpecBuilder);
        if (functionConfig.getTenant() != null) {
            functionDetailsBuilder.setTenant(functionConfig.getTenant());
        }
        if (functionConfig.getNamespace() != null) {
            functionDetailsBuilder.setNamespace(functionConfig.getNamespace());
        }
        if (functionConfig.getName() != null) {
            functionDetailsBuilder.setName(functionConfig.getName());
        }
        if (functionConfig.getLogTopic() != null) {
            functionDetailsBuilder.setLogTopic(functionConfig.getLogTopic());
        }
        if (functionConfig.getRuntime() != null) {
            functionDetailsBuilder.setRuntime(FunctionCommon.convertRuntime(functionConfig.getRuntime()));
        }
        if (functionConfig.getProcessingGuarantees() != null) {
            functionDetailsBuilder.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(functionConfig.getProcessingGuarantees()));
        }
        if (functionConfig.getRetainKeyOrdering() != null) {
            functionDetailsBuilder.setRetainKeyOrdering(functionConfig.getRetainKeyOrdering());
        }
        if (functionConfig.getRetainOrdering() != null) {
            functionDetailsBuilder.setRetainOrdering(functionConfig.getRetainOrdering());
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0) {
            Function.RetryDetails.Builder retryBuilder = Function.RetryDetails.newBuilder();
            retryBuilder.setMaxMessageRetries(functionConfig.getMaxMessageRetries());
            if (StringUtils.isNotEmpty(functionConfig.getDeadLetterTopic())) {
                retryBuilder.setDeadLetterTopic(functionConfig.getDeadLetterTopic());
            }
            functionDetailsBuilder.setRetryDetails(retryBuilder);
        }
        HashMap<String, Object> configs = new HashMap<String, Object>();
        if (functionConfig.getUserConfig() != null) {
            configs.putAll(functionConfig.getUserConfig());
        }
        if ((windowConfig = functionConfig.getWindowConfig()) != null) {
            windowConfig.setActualWindowFunctionClassName(functionConfig.getClassName());
            configs.put("__WINDOWCONFIGS__", windowConfig);
            functionDetailsBuilder.setClassName("org.apache.pulsar.functions.windowing.WindowFunctionExecutor");
        } else if (functionConfig.getClassName() != null) {
            functionDetailsBuilder.setClassName(functionConfig.getClassName());
        }
        if (!configs.isEmpty()) {
            functionDetailsBuilder.setUserConfig(new Gson().toJson(configs));
        }
        if (functionConfig.getSecrets() != null && !functionConfig.getSecrets().isEmpty()) {
            functionDetailsBuilder.setSecretsMap(new Gson().toJson(functionConfig.getSecrets()));
        }
        if (functionConfig.getAutoAck() != null) {
            functionDetailsBuilder.setAutoAck(functionConfig.getAutoAck());
        } else {
            functionDetailsBuilder.setAutoAck(true);
        }
        if (functionConfig.getParallelism() != null) {
            functionDetailsBuilder.setParallelism(functionConfig.getParallelism());
        } else {
            functionDetailsBuilder.setParallelism(1);
        }
        Resources resources = Resources.mergeWithDefault(functionConfig.getResources());
        Function.Resources.Builder bldr = Function.Resources.newBuilder();
        bldr.setCpu(resources.getCpu());
        bldr.setRam(resources.getRam());
        bldr.setDisk(resources.getDisk());
        functionDetailsBuilder.setResources(bldr);
        if (!StringUtils.isEmpty(functionConfig.getRuntimeFlags())) {
            functionDetailsBuilder.setRuntimeFlags(functionConfig.getRuntimeFlags());
        }
        functionDetailsBuilder.setComponentType(Function.FunctionDetails.ComponentType.FUNCTION);
        if (!StringUtils.isEmpty(functionConfig.getCustomRuntimeOptions())) {
            functionDetailsBuilder.setCustomRuntimeOptions(functionConfig.getCustomRuntimeOptions());
        }
        if (isBuiltin) {
            String builtin = functionConfig.getJar().replaceFirst("^builtin://", "");
            functionDetailsBuilder.setBuiltin(builtin);
        }
        return functionDetailsBuilder.build();
    }

    public static FunctionConfig convertFromDetails(Function.FunctionDetails functionDetails) {
        HashMap<String, Object> userConfig;
        Type type;
        FunctionConfig functionConfig = new FunctionConfig();
        functionConfig.setTenant(functionDetails.getTenant());
        functionConfig.setNamespace(functionDetails.getNamespace());
        functionConfig.setName(functionDetails.getName());
        functionConfig.setParallelism(functionDetails.getParallelism());
        functionConfig.setProcessingGuarantees(FunctionCommon.convertProcessingGuarantee(functionDetails.getProcessingGuarantees()));
        HashMap<String, ConsumerConfig> consumerConfigMap = new HashMap<String, ConsumerConfig>();
        for (Map.Entry<String, Function.ConsumerSpec> input : functionDetails.getSource().getInputSpecsMap().entrySet()) {
            ConsumerConfig consumerConfig = new ConsumerConfig();
            if (StringUtils.isNotEmpty(input.getValue().getSerdeClassName())) {
                consumerConfig.setSerdeClassName(input.getValue().getSerdeClassName());
            }
            if (StringUtils.isNotEmpty(input.getValue().getSchemaType())) {
                consumerConfig.setSchemaType(input.getValue().getSchemaType());
            }
            if (input.getValue().hasReceiverQueueSize()) {
                consumerConfig.setReceiverQueueSize(input.getValue().getReceiverQueueSize().getValue());
            }
            if (input.getValue().hasCryptoSpec()) {
                consumerConfig.setCryptoConfig(CryptoUtils.convertFromSpec(input.getValue().getCryptoSpec()));
            }
            consumerConfig.setRegexPattern(input.getValue().getIsRegexPattern());
            consumerConfig.setSchemaProperties(input.getValue().getSchemaPropertiesMap());
            consumerConfig.setPoolMessages(input.getValue().getPoolMessages());
            consumerConfigMap.put(input.getKey(), consumerConfig);
        }
        functionConfig.setInputSpecs(consumerConfigMap);
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getSource().getSubscriptionName())) {
            functionConfig.setSubName(functionDetails.getSource().getSubscriptionName());
        }
        functionConfig.setRetainOrdering(functionDetails.getRetainOrdering());
        functionConfig.setRetainKeyOrdering(functionDetails.getRetainKeyOrdering());
        functionConfig.setCleanupSubscription(functionDetails.getSource().getCleanupSubscription());
        functionConfig.setAutoAck(functionDetails.getAutoAck());
        functionConfig.setSubscriptionPosition(FunctionCommon.convertFromFunctionDetailsSubscriptionPosition(functionDetails.getSource().getSubscriptionPosition()));
        if (functionDetails.getSource().getTimeoutMs() != 0L) {
            functionConfig.setTimeoutMs(functionDetails.getSource().getTimeoutMs());
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getSink().getTopic())) {
            functionConfig.setOutput(functionDetails.getSink().getTopic());
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getSink().getSerDeClassName())) {
            functionConfig.setOutputSerdeClassName(functionDetails.getSink().getSerDeClassName());
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getSink().getSchemaType())) {
            functionConfig.setOutputSchemaType(functionDetails.getSink().getSchemaType());
        }
        if (functionDetails.getSink().getProducerSpec() != null) {
            Function.ProducerSpec spec = functionDetails.getSink().getProducerSpec();
            ProducerConfig producerConfig = new ProducerConfig();
            if (spec.getMaxPendingMessages() != 0) {
                producerConfig.setMaxPendingMessages(spec.getMaxPendingMessages());
            }
            if (spec.getMaxPendingMessagesAcrossPartitions() != 0) {
                producerConfig.setMaxPendingMessagesAcrossPartitions(spec.getMaxPendingMessagesAcrossPartitions());
            }
            if (spec.hasCryptoSpec()) {
                producerConfig.setCryptoConfig(CryptoUtils.convertFromSpec(spec.getCryptoSpec()));
            }
            if (spec.getBatchBuilder() != null) {
                producerConfig.setBatchBuilder(spec.getBatchBuilder());
            }
            producerConfig.setUseThreadLocalProducers(spec.getUseThreadLocalProducers());
            functionConfig.setProducerConfig(producerConfig);
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getLogTopic())) {
            functionConfig.setLogTopic(functionDetails.getLogTopic());
        }
        if (functionDetails.getSink().getForwardSourceMessageProperty()) {
            functionConfig.setForwardSourceMessageProperty(functionDetails.getSink().getForwardSourceMessageProperty());
        }
        functionConfig.setRuntime(FunctionCommon.convertRuntime(functionDetails.getRuntime()));
        if (functionDetails.hasRetryDetails()) {
            functionConfig.setMaxMessageRetries(functionDetails.getRetryDetails().getMaxMessageRetries());
            if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getRetryDetails().getDeadLetterTopic())) {
                functionConfig.setDeadLetterTopic(functionDetails.getRetryDetails().getDeadLetterTopic());
            }
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getUserConfig())) {
            type = new TypeToken<Map<String, Object>>(){}.getType();
            userConfig = (Map)new Gson().fromJson(functionDetails.getUserConfig(), type);
        } else {
            userConfig = new HashMap();
        }
        if (userConfig.containsKey("__WINDOWCONFIGS__")) {
            WindowConfig windowConfig = new Gson().fromJson(new Gson().toJson(userConfig.get("__WINDOWCONFIGS__")), WindowConfig.class);
            userConfig.remove("__WINDOWCONFIGS__");
            functionConfig.setClassName(windowConfig.getActualWindowFunctionClassName());
            functionConfig.setWindowConfig(windowConfig);
        } else {
            functionConfig.setClassName(functionDetails.getClassName());
        }
        functionConfig.setUserConfig(userConfig);
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getSecretsMap())) {
            type = new TypeToken<Map<String, Object>>(){}.getType();
            Map secretsMap = (Map)new Gson().fromJson(functionDetails.getSecretsMap(), type);
            functionConfig.setSecrets(secretsMap);
        }
        if (functionDetails.hasResources()) {
            Resources resources = new Resources();
            resources.setCpu(functionDetails.getResources().getCpu());
            resources.setRam(functionDetails.getResources().getRam());
            resources.setDisk(functionDetails.getResources().getDisk());
            functionConfig.setResources(resources);
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getRuntimeFlags())) {
            functionConfig.setRuntimeFlags(functionDetails.getRuntimeFlags());
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionDetails.getCustomRuntimeOptions())) {
            functionConfig.setCustomRuntimeOptions(functionDetails.getCustomRuntimeOptions());
        }
        return functionConfig;
    }

    public static void inferMissingArguments(FunctionConfig functionConfig, boolean forwardSourceMessagePropertyEnabled) {
        if (StringUtils.isEmpty(functionConfig.getName())) {
            Utils.inferMissingFunctionName(functionConfig);
        }
        if (StringUtils.isEmpty(functionConfig.getTenant())) {
            Utils.inferMissingTenant(functionConfig);
        }
        if (StringUtils.isEmpty(functionConfig.getNamespace())) {
            Utils.inferMissingNamespace(functionConfig);
        }
        if (functionConfig.getParallelism() == null) {
            functionConfig.setParallelism(1);
        }
        if (functionConfig.getMaxPendingAsyncRequests() == null) {
            functionConfig.setMaxPendingAsyncRequests(MAX_PENDING_ASYNC_REQUESTS_DEFAULT);
        }
        if (forwardSourceMessagePropertyEnabled) {
            if (functionConfig.getForwardSourceMessageProperty() == null) {
                functionConfig.setForwardSourceMessageProperty(FORWARD_SOURCE_MESSAGE_PROPERTY_DEFAULT);
            }
        } else {
            functionConfig.setForwardSourceMessageProperty(null);
        }
        if (functionConfig.getJar() != null) {
            functionConfig.setRuntime(FunctionConfig.Runtime.JAVA);
        } else if (functionConfig.getPy() != null) {
            functionConfig.setRuntime(FunctionConfig.Runtime.PYTHON);
        } else if (functionConfig.getGo() != null) {
            functionConfig.setRuntime(FunctionConfig.Runtime.GO);
        }
        WindowConfig windowConfig = functionConfig.getWindowConfig();
        if (windowConfig != null) {
            WindowConfigUtils.inferMissingArguments(windowConfig);
            functionConfig.setAutoAck(false);
        }
    }

    private static void doJavaChecks(FunctionConfig functionConfig, ClassLoader clsLoader) {
        Class[] typeArgs;
        try {
            Class<?> functionClass = clsLoader.loadClass(functionConfig.getClassName());
            if (!(org.apache.pulsar.functions.api.Function.class.isAssignableFrom(functionClass) || Function.class.isAssignableFrom(functionClass) || WindowFunction.class.isAssignableFrom(functionClass))) {
                throw new IllegalArgumentException(String.format("Function class %s does not implement the correct interface", functionClass.getName()));
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("Function class %s must be in class path", functionConfig.getClassName()), e);
        }
        try {
            typeArgs = FunctionCommon.getFunctionTypes(functionConfig, clsLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new IllegalArgumentException(String.format("Function class %s must be in class path", functionConfig.getClassName()), e);
        }
        if (functionConfig.getCustomSerdeInputs() != null) {
            functionConfig.getCustomSerdeInputs().forEach((topicName, inputSerializer) -> ValidatorUtils.validateSerde(inputSerializer, typeArgs[0], clsLoader, true));
        }
        if (functionConfig.getCustomSchemaInputs() != null) {
            functionConfig.getCustomSchemaInputs().forEach((topicName, conf) -> {
                ConsumerConfig consumerConfig;
                try {
                    consumerConfig = OBJECT_MAPPER.readValue((String)conf, ConsumerConfig.class);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException(String.format("Topic %s has an incorrect schema Info", topicName));
                }
                ValidatorUtils.validateSchema(consumerConfig.getSchemaType(), typeArgs[0], clsLoader, true);
            });
        }
        if (functionConfig.getInputSpecs() != null) {
            functionConfig.getInputSpecs().forEach((topicName, conf) -> {
                if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(conf.getSchemaType()) && !org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(conf.getSerdeClassName())) {
                    throw new IllegalArgumentException("Only one of schemaType or serdeClassName should be set in inputSpec");
                }
                if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(conf.getSerdeClassName())) {
                    ValidatorUtils.validateSerde(conf.getSerdeClassName(), typeArgs[0], clsLoader, true);
                }
                if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(conf.getSchemaType())) {
                    ValidatorUtils.validateSchema(conf.getSchemaType(), typeArgs[0], clsLoader, true);
                }
                if (conf.getCryptoConfig() != null) {
                    ValidatorUtils.validateCryptoKeyReader(conf.getCryptoConfig(), clsLoader, false);
                }
            });
        }
        if (Void.class.equals((Object)typeArgs[1])) {
            return;
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getOutputSerdeClassName()) && !org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getOutputSchemaType())) {
            throw new IllegalArgumentException("Only one of outputSchemaType or outputSerdeClassName should be set");
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getOutputSchemaType())) {
            ValidatorUtils.validateSchema(functionConfig.getOutputSchemaType(), typeArgs[1], clsLoader, false);
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getOutputSerdeClassName())) {
            ValidatorUtils.validateSerde(functionConfig.getOutputSerdeClassName(), typeArgs[1], clsLoader, false);
        }
        if (functionConfig.getProducerConfig() != null && functionConfig.getProducerConfig().getCryptoConfig() != null) {
            ValidatorUtils.validateCryptoKeyReader(functionConfig.getProducerConfig().getCryptoConfig(), clsLoader, true);
        }
    }

    private static void doPythonChecks(FunctionConfig functionConfig) {
        if (functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new RuntimeException("Effectively-once processing guarantees not yet supported in Python");
        }
        if (functionConfig.getWindowConfig() != null) {
            throw new IllegalArgumentException("There is currently no support windowing in python");
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0) {
            throw new IllegalArgumentException("Message retries not yet supported in python");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue()) {
            throw new IllegalArgumentException("Retain Key Orderering not yet supported in python");
        }
    }

    private static void doGolangChecks(FunctionConfig functionConfig) {
        if (functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new RuntimeException("Effectively-once processing guarantees not yet supported in Go function");
        }
        if (functionConfig.getWindowConfig() != null) {
            throw new IllegalArgumentException("Windowing is not supported in Go function yet");
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0) {
            throw new IllegalArgumentException("Message retries not yet supported in Go function");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue()) {
            throw new IllegalArgumentException("Retain Key Orderering not yet supported in Go function");
        }
    }

    private static void verifyNoTopicClash(Collection<String> inputTopics, String outputTopic) throws IllegalArgumentException {
        if (inputTopics.contains(outputTopic)) {
            throw new IllegalArgumentException(String.format("Output topic %s is also being used as an input topic (topics must be one or the other)", outputTopic));
        }
    }

    private static void doCommonChecks(FunctionConfig functionConfig) {
        if (org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getTenant())) {
            throw new IllegalArgumentException("Function tenant cannot be null");
        }
        if (org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getNamespace())) {
            throw new IllegalArgumentException("Function namespace cannot be null");
        }
        if (org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getName())) {
            throw new IllegalArgumentException("Function name cannot be null");
        }
        if ((functionConfig.getRuntime() == FunctionConfig.Runtime.PYTHON || functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA) && org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getClassName())) {
            throw new IllegalArgumentException("Function classname cannot be null");
        }
        Collection<String> allInputTopics = FunctionConfigUtils.collectAllInputTopics(functionConfig);
        if (allInputTopics.isEmpty()) {
            throw new IllegalArgumentException("No input topic(s) specified for the function");
        }
        for (String topic : allInputTopics) {
            if (TopicName.isValid(topic)) continue;
            throw new IllegalArgumentException(String.format("Input topic %s is invalid", topic));
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getOutput()) && !TopicName.isValid(functionConfig.getOutput())) {
            throw new IllegalArgumentException(String.format("Output topic %s is invalid", functionConfig.getOutput()));
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getLogTopic()) && !TopicName.isValid(functionConfig.getLogTopic())) {
            throw new IllegalArgumentException(String.format("LogTopic topic %s is invalid", functionConfig.getLogTopic()));
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getDeadLetterTopic()) && !TopicName.isValid(functionConfig.getDeadLetterTopic())) {
            throw new IllegalArgumentException(String.format("DeadLetter topic %s is invalid", functionConfig.getDeadLetterTopic()));
        }
        if (functionConfig.getParallelism() != null && functionConfig.getParallelism() <= 0) {
            throw new IllegalArgumentException("Function parallelism must be a positive number");
        }
        FunctionConfigUtils.verifyNoTopicClash(allInputTopics, functionConfig.getOutput());
        WindowConfig windowConfig = functionConfig.getWindowConfig();
        if (windowConfig != null) {
            if (functionConfig.getAutoAck() != null && functionConfig.getAutoAck().booleanValue()) {
                throw new IllegalArgumentException("Cannot enable auto ack when using windowing functionality");
            }
            WindowConfigUtils.validate(windowConfig);
        }
        if (functionConfig.getResources() != null) {
            ResourceConfigUtils.validate(functionConfig.getResources());
        }
        if (functionConfig.getTimeoutMs() != null && functionConfig.getTimeoutMs() <= 0L) {
            throw new IllegalArgumentException("Function timeout must be a positive number");
        }
        if (functionConfig.getTimeoutMs() != null && functionConfig.getProcessingGuarantees() != null && functionConfig.getProcessingGuarantees() != FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE) {
            throw new IllegalArgumentException("Message timeout can only be specified with processing guarantee is " + FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE.name());
        }
        if (functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0 && functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new IllegalArgumentException("MaxMessageRetries and Effectively once don't gel well");
        }
        if (!(functionConfig.getMaxMessageRetries() != null && functionConfig.getMaxMessageRetries() >= 0 || org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getDeadLetterTopic()))) {
            throw new IllegalArgumentException("Dead Letter Topic specified, however max retries is set to infinity");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue() && functionConfig.getProcessingGuarantees() != null && functionConfig.getProcessingGuarantees() == FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE) {
            throw new IllegalArgumentException("When effectively once processing guarantee is specified, retain Key ordering cannot be set");
        }
        if (functionConfig.getRetainKeyOrdering() != null && functionConfig.getRetainKeyOrdering().booleanValue() && functionConfig.getRetainOrdering() != null && functionConfig.getRetainOrdering().booleanValue()) {
            throw new IllegalArgumentException("Only one of retain ordering or retain key ordering can be set");
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getPy()) && !Utils.isFunctionPackageUrlSupported(functionConfig.getPy()) && functionConfig.getPy().startsWith("builtin") && !new File(functionConfig.getPy()).exists()) {
            throw new IllegalArgumentException("The supplied python file does not exist");
        }
        if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getGo()) && !Utils.isFunctionPackageUrlSupported(functionConfig.getGo()) && functionConfig.getGo().startsWith("builtin") && !new File(functionConfig.getGo()).exists()) {
            throw new IllegalArgumentException("The supplied go file does not exist");
        }
        if (functionConfig.getInputSpecs() != null) {
            functionConfig.getInputSpecs().forEach((topicName, conf) -> {
                if (conf.getReceiverQueueSize() != null && conf.getReceiverQueueSize() < 0) {
                    throw new IllegalArgumentException("Receiver queue size should be >= zero");
                }
                if (conf.getCryptoConfig() != null && StringUtils.isBlank(conf.getCryptoConfig().getCryptoKeyReaderClassName())) {
                    throw new IllegalArgumentException("CryptoKeyReader class name required");
                }
            });
        }
        if (functionConfig.getProducerConfig() != null && functionConfig.getProducerConfig().getCryptoConfig() != null) {
            if (StringUtils.isBlank(functionConfig.getProducerConfig().getCryptoConfig().getCryptoKeyReaderClassName())) {
                throw new IllegalArgumentException("CryptoKeyReader class name required");
            }
            if (functionConfig.getProducerConfig().getCryptoConfig().getEncryptionKeys() == null || functionConfig.getProducerConfig().getCryptoConfig().getEncryptionKeys().length == 0) {
                throw new IllegalArgumentException("Must provide encryption key name for crypto key reader");
            }
        }
    }

    private static Collection<String> collectAllInputTopics(FunctionConfig functionConfig) {
        LinkedList<String> retval = new LinkedList<String>();
        if (functionConfig.getInputs() != null) {
            retval.addAll(functionConfig.getInputs());
        }
        if (functionConfig.getTopicsPattern() != null) {
            retval.add(functionConfig.getTopicsPattern());
        }
        if (functionConfig.getCustomSerdeInputs() != null) {
            retval.addAll(functionConfig.getCustomSerdeInputs().keySet());
        }
        if (functionConfig.getCustomSchemaInputs() != null) {
            retval.addAll(functionConfig.getCustomSchemaInputs().keySet());
        }
        if (functionConfig.getInputSpecs() != null) {
            retval.addAll(functionConfig.getInputSpecs().keySet());
        }
        return retval;
    }

    public static ClassLoader validate(FunctionConfig functionConfig, File functionPackageFile) {
        FunctionConfigUtils.doCommonChecks(functionConfig);
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA) {
            ClassLoader classLoader = null;
            if (functionPackageFile != null) {
                try {
                    classLoader = ClassLoaderUtils.loadJar(functionPackageFile);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Corrupted Jar File", e);
                }
            } else if (!org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang3.StringUtils.isEmpty(functionConfig.getJar())) {
                File jarFile = new File(functionConfig.getJar());
                if (!jarFile.exists()) {
                    throw new IllegalArgumentException("Jar file does not exist");
                }
                try {
                    classLoader = ClassLoaderUtils.loadJar(jarFile);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Corrupted Jar File", e);
                }
            } else {
                throw new IllegalArgumentException("Function Package is not provided");
            }
            FunctionConfigUtils.doJavaChecks(functionConfig, classLoader);
            return classLoader;
        }
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.GO) {
            FunctionConfigUtils.doGolangChecks(functionConfig);
            return null;
        }
        if (functionConfig.getRuntime() == FunctionConfig.Runtime.PYTHON) {
            FunctionConfigUtils.doPythonChecks(functionConfig);
            return null;
        }
        throw new IllegalArgumentException("Function language runtime is either not set or cannot be determined");
    }

    public static void validateJavaFunction(FunctionConfig functionConfig, ClassLoader classLoader) {
        FunctionConfigUtils.doCommonChecks(functionConfig);
        FunctionConfigUtils.doJavaChecks(functionConfig, classLoader);
    }

    public static FunctionConfig validateUpdate(FunctionConfig existingConfig, FunctionConfig newConfig) {
        FunctionConfig mergedConfig = existingConfig.toBuilder().build();
        if (!existingConfig.getTenant().equals(newConfig.getTenant())) {
            throw new IllegalArgumentException("Tenants differ");
        }
        if (!existingConfig.getNamespace().equals(newConfig.getNamespace())) {
            throw new IllegalArgumentException("Namespaces differ");
        }
        if (!existingConfig.getName().equals(newConfig.getName())) {
            throw new IllegalArgumentException("Function Names differ");
        }
        if (!StringUtils.isEmpty(newConfig.getClassName())) {
            mergedConfig.setClassName(newConfig.getClassName());
        }
        if (!StringUtils.isEmpty(newConfig.getJar())) {
            mergedConfig.setJar(newConfig.getJar());
        }
        if (newConfig.getInputSpecs() == null) {
            newConfig.setInputSpecs(new HashMap<String, ConsumerConfig>());
        }
        if (mergedConfig.getInputSpecs() == null) {
            mergedConfig.setInputSpecs(new HashMap<String, ConsumerConfig>());
        }
        if (newConfig.getInputs() != null) {
            newConfig.getInputs().forEach(topicName -> newConfig.getInputSpecs().put((String)topicName, ConsumerConfig.builder().isRegexPattern(false).build()));
        }
        if (newConfig.getTopicsPattern() != null && !newConfig.getTopicsPattern().isEmpty()) {
            newConfig.getInputSpecs().put(newConfig.getTopicsPattern(), ConsumerConfig.builder().isRegexPattern(true).build());
        }
        if (newConfig.getCustomSerdeInputs() != null) {
            newConfig.getCustomSerdeInputs().forEach((topicName, serdeClassName) -> newConfig.getInputSpecs().put((String)topicName, ConsumerConfig.builder().serdeClassName((String)serdeClassName).isRegexPattern(false).build()));
        }
        if (newConfig.getCustomSchemaInputs() != null) {
            newConfig.getCustomSchemaInputs().forEach((topicName, schemaClassname) -> newConfig.getInputSpecs().put((String)topicName, ConsumerConfig.builder().schemaType((String)schemaClassname).isRegexPattern(false).build()));
        }
        if (!newConfig.getInputSpecs().isEmpty()) {
            newConfig.getInputSpecs().forEach((topicName, consumerConfig) -> {
                if (!existingConfig.getInputSpecs().containsKey(topicName)) {
                    throw new IllegalArgumentException("Input Topics cannot be altered");
                }
                if (consumerConfig.isRegexPattern() != existingConfig.getInputSpecs().get(topicName).isRegexPattern()) {
                    throw new IllegalArgumentException("isRegexPattern for input topic " + topicName + " cannot be altered");
                }
                mergedConfig.getInputSpecs().put((String)topicName, (ConsumerConfig)consumerConfig);
            });
        }
        if (!StringUtils.isEmpty(newConfig.getOutputSerdeClassName()) && !newConfig.getOutputSerdeClassName().equals(existingConfig.getOutputSerdeClassName())) {
            throw new IllegalArgumentException("Output Serde mismatch");
        }
        if (!StringUtils.isEmpty(newConfig.getOutputSchemaType()) && !newConfig.getOutputSchemaType().equals(existingConfig.getOutputSchemaType())) {
            throw new IllegalArgumentException("Output Schema mismatch");
        }
        if (!StringUtils.isEmpty(newConfig.getLogTopic())) {
            mergedConfig.setLogTopic(newConfig.getLogTopic());
        }
        if (newConfig.getProcessingGuarantees() != null && !newConfig.getProcessingGuarantees().equals((Object)existingConfig.getProcessingGuarantees())) {
            throw new IllegalArgumentException("Processing Guarantees cannot be altered");
        }
        if (newConfig.getRetainOrdering() != null && !newConfig.getRetainOrdering().equals(existingConfig.getRetainOrdering())) {
            throw new IllegalArgumentException("Retain Ordering cannot be altered");
        }
        if (newConfig.getRetainKeyOrdering() != null && !newConfig.getRetainKeyOrdering().equals(existingConfig.getRetainKeyOrdering())) {
            throw new IllegalArgumentException("Retain Key Ordering cannot be altered");
        }
        if (!StringUtils.isEmpty(newConfig.getOutput())) {
            mergedConfig.setOutput(newConfig.getOutput());
        }
        if (newConfig.getUserConfig() != null) {
            mergedConfig.setUserConfig(newConfig.getUserConfig());
        }
        if (newConfig.getSecrets() != null) {
            mergedConfig.setSecrets(newConfig.getSecrets());
        }
        if (newConfig.getRuntime() != null && !newConfig.getRuntime().equals((Object)existingConfig.getRuntime())) {
            throw new IllegalArgumentException("Runtime cannot be altered");
        }
        if (newConfig.getAutoAck() != null && !newConfig.getAutoAck().equals(existingConfig.getAutoAck())) {
            throw new IllegalArgumentException("AutoAck cannot be altered");
        }
        if (newConfig.getMaxMessageRetries() != null) {
            mergedConfig.setMaxMessageRetries(newConfig.getMaxMessageRetries());
        }
        if (!StringUtils.isEmpty(newConfig.getDeadLetterTopic())) {
            mergedConfig.setDeadLetterTopic(newConfig.getDeadLetterTopic());
        }
        if (!StringUtils.isEmpty(newConfig.getSubName()) && !newConfig.getSubName().equals(existingConfig.getSubName())) {
            throw new IllegalArgumentException("Subscription Name cannot be altered");
        }
        if (newConfig.getParallelism() != null) {
            mergedConfig.setParallelism(newConfig.getParallelism());
        }
        if (newConfig.getResources() != null) {
            mergedConfig.setResources(ResourceConfigUtils.merge(existingConfig.getResources(), newConfig.getResources()));
        }
        if (newConfig.getWindowConfig() != null) {
            mergedConfig.setWindowConfig(newConfig.getWindowConfig());
        }
        if (newConfig.getTimeoutMs() != null) {
            mergedConfig.setTimeoutMs(newConfig.getTimeoutMs());
        }
        if (newConfig.getCleanupSubscription() != null) {
            mergedConfig.setCleanupSubscription(newConfig.getCleanupSubscription());
        }
        if (!StringUtils.isEmpty(newConfig.getRuntimeFlags())) {
            mergedConfig.setRuntimeFlags(newConfig.getRuntimeFlags());
        }
        if (!StringUtils.isEmpty(newConfig.getCustomRuntimeOptions())) {
            mergedConfig.setCustomRuntimeOptions(newConfig.getCustomRuntimeOptions());
        }
        return mergedConfig;
    }
}

