/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.coordination.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.coordination.LeaderElection;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.LeaderElectionImpl;
import org.apache.pulsar.metadata.coordination.impl.LockManagerImpl;

public class CoordinationServiceImpl
implements CoordinationService {
    private final MetadataStoreExtended store;
    private final Map<Object, LockManager<?>> lockManagers = new ConcurrentHashMap();
    private final Map<String, LeaderElection<?>> leaderElections = new ConcurrentHashMap();
    private final ScheduledExecutorService executor;

    public CoordinationServiceImpl(MetadataStoreExtended store) {
        this.store = store;
        this.executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("metadata-store-coordination-service"));
    }

    @Override
    public void close() throws Exception {
        try {
            ArrayList futures = new ArrayList();
            for (LeaderElection<?> leaderElection : this.leaderElections.values()) {
                futures.add(leaderElection.asyncClose());
            }
            for (LockManager lockManager : this.lockManagers.values()) {
                futures.add(lockManager.asyncClose());
            }
            FutureUtils.collect(futures).join();
        }
        catch (CompletionException ce) {
            throw MetadataStoreException.unwrap(ce);
        }
    }

    @Override
    public <T> LockManager<T> getLockManager(Class<T> clazz) {
        return this.lockManagers.computeIfAbsent(clazz, k -> new LockManagerImpl(this.store, clazz, (ExecutorService)this.executor));
    }

    @Override
    public <T> LockManager<T> getLockManager(MetadataSerde<T> serde) {
        return this.lockManagers.computeIfAbsent(serde, k -> new LockManagerImpl(this.store, serde, (ExecutorService)this.executor));
    }

    @Override
    public CompletableFuture<Long> getNextCounterValue(String path) {
        return this.store.exists(path).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.incrementCounter(path);
            }
            return this.store.put(path, new byte[0], Optional.empty()).thenCompose(__ -> this.incrementCounter(path));
        });
    }

    private CompletableFuture<Long> incrementCounter(String path) {
        String counterBasePath = path + "/-";
        return this.store.put(counterBasePath, new byte[0], Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral, CreateOption.Sequential)).thenApply(stat -> {
            String[] parts = stat.getPath().split("/");
            String seq = parts[parts.length - 1].replace('-', ' ').trim();
            return Long.parseLong(seq);
        });
    }

    @Override
    public <T> LeaderElection<T> getLeaderElection(Class<T> clazz, String path, Consumer<LeaderElectionState> stateChangesListener) {
        return this.leaderElections.computeIfAbsent(path, key -> new LeaderElectionImpl(this.store, clazz, path, stateChangesListener, this.executor));
    }
}

