/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.policies.data.loadbalancer;

import java.net.URI;

public class AdvertisedListener {
    private URI brokerServiceUrl;
    private URI brokerServiceUrlTls;
    private URI brokerHttpUrl;
    private URI brokerHttpsUrl;

    public boolean hasUriForProtocol(String protocol) {
        if ("pulsar".equals(protocol)) {
            return this.brokerServiceUrl != null;
        }
        if ("pulsar+ssl".equals(protocol)) {
            return this.brokerServiceUrlTls != null;
        }
        if ("http".equals(protocol)) {
            return this.brokerHttpUrl != null;
        }
        if ("https".equals(protocol)) {
            return this.brokerHttpsUrl != null;
        }
        return false;
    }

    public static AdvertisedListenerBuilder builder() {
        return new AdvertisedListenerBuilder();
    }

    public AdvertisedListener() {
    }

    public AdvertisedListener(URI brokerServiceUrl, URI brokerServiceUrlTls, URI brokerHttpUrl, URI brokerHttpsUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.brokerHttpUrl = brokerHttpUrl;
        this.brokerHttpsUrl = brokerHttpsUrl;
    }

    public String toString() {
        return "AdvertisedListener(brokerServiceUrl=" + this.getBrokerServiceUrl() + ", brokerServiceUrlTls=" + this.getBrokerServiceUrlTls() + ", brokerHttpUrl=" + this.getBrokerHttpUrl() + ", brokerHttpsUrl=" + this.getBrokerHttpsUrl() + ")";
    }

    public URI getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public void setBrokerServiceUrl(URI brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public URI getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public void setBrokerServiceUrlTls(URI brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public URI getBrokerHttpUrl() {
        return this.brokerHttpUrl;
    }

    public void setBrokerHttpUrl(URI brokerHttpUrl) {
        this.brokerHttpUrl = brokerHttpUrl;
    }

    public URI getBrokerHttpsUrl() {
        return this.brokerHttpsUrl;
    }

    public void setBrokerHttpsUrl(URI brokerHttpsUrl) {
        this.brokerHttpsUrl = brokerHttpsUrl;
    }

    public static class AdvertisedListenerBuilder {
        private URI brokerServiceUrl;
        private URI brokerServiceUrlTls;
        private URI brokerHttpUrl;
        private URI brokerHttpsUrl;

        AdvertisedListenerBuilder() {
        }

        public AdvertisedListenerBuilder brokerServiceUrl(URI brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
            return this;
        }

        public AdvertisedListenerBuilder brokerServiceUrlTls(URI brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
            return this;
        }

        public AdvertisedListenerBuilder brokerHttpUrl(URI brokerHttpUrl) {
            this.brokerHttpUrl = brokerHttpUrl;
            return this;
        }

        public AdvertisedListenerBuilder brokerHttpsUrl(URI brokerHttpsUrl) {
            this.brokerHttpsUrl = brokerHttpsUrl;
            return this;
        }

        public AdvertisedListener build() {
            return new AdvertisedListener(this.brokerServiceUrl, this.brokerServiceUrlTls, this.brokerHttpUrl, this.brokerHttpsUrl);
        }

        public String toString() {
            return "AdvertisedListener.AdvertisedListenerBuilder(brokerServiceUrl=" + this.brokerServiceUrl + ", brokerServiceUrlTls=" + this.brokerServiceUrlTls + ", brokerHttpUrl=" + this.brokerHttpUrl + ", brokerHttpsUrl=" + this.brokerHttpsUrl + ")";
        }
    }
}

