/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Properties;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Tenants;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;

public class TenantsImpl
extends BaseResource
implements Tenants,
Properties {
    private final WebTarget adminTenants;

    public TenantsImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.adminTenants = web.path("/admin/v2/tenants");
    }

    @Override
    public List<String> getTenants() throws PulsarAdminException {
        return (List)this.sync(() -> this.getTenantsAsync());
    }

    @Override
    public CompletableFuture<List<String>> getTenantsAsync() {
        return this.asyncGetRequest(this.adminTenants, new BaseResource.FutureCallback<List<String>>(){});
    }

    @Override
    public TenantInfo getTenantInfo(String tenant) throws PulsarAdminException {
        return (TenantInfo)this.sync(() -> this.getTenantInfoAsync(tenant));
    }

    @Override
    public CompletableFuture<TenantInfo> getTenantInfoAsync(String tenant) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TenantInfoImpl>(){}).thenApply(tenantInfo -> tenantInfo);
    }

    @Override
    public void createTenant(String tenant, TenantInfo config) throws PulsarAdminException {
        this.sync(() -> this.createTenantAsync(tenant, config));
    }

    @Override
    public CompletableFuture<Void> createTenantAsync(String tenant, TenantInfo config) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncPutRequest(path, Entity.entity(config, "application/json"));
    }

    @Override
    public void updateTenant(String tenant, TenantInfo config) throws PulsarAdminException {
        this.sync(() -> this.updateTenantAsync(tenant, config));
    }

    @Override
    public CompletableFuture<Void> updateTenantAsync(String tenant, TenantInfo config) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncPostRequest(path, Entity.entity((TenantInfoImpl)config, "application/json"));
    }

    @Override
    public void deleteTenant(String tenant) throws PulsarAdminException {
        this.sync(() -> this.deleteTenantAsync(tenant));
    }

    @Override
    public void deleteTenant(String tenant, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteTenantAsync(tenant, force));
    }

    @Override
    public CompletableFuture<Void> deleteTenantAsync(String tenant) {
        return this.deleteTenantAsync(tenant, false);
    }

    @Override
    public CompletableFuture<Void> deleteTenantAsync(String tenant, boolean force) {
        WebTarget path = this.adminTenants.path(tenant);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void createProperty(String tenant, TenantInfo config) throws PulsarAdminException {
        this.createTenant(tenant, config);
    }

    @Override
    public void updateProperty(String tenant, TenantInfo config) throws PulsarAdminException {
        this.updateTenant(tenant, config);
    }

    @Override
    public void deleteProperty(String tenant) throws PulsarAdminException {
        this.deleteTenant(tenant);
    }

    @Override
    public List<String> getProperties() throws PulsarAdminException {
        return this.getTenants();
    }

    @Override
    public TenantInfo getPropertyAdmin(String tenant) throws PulsarAdminException {
        return this.getTenantInfo(tenant);
    }

    public WebTarget getWebTarget() {
        return this.adminTenants;
    }
}

