/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.time.Clock;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.TopicMetadata;
import org.apache.pulsar.client.impl.RoundRobinPartitionMessageRouterImpl;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;

public class FunctionResultRouter
extends RoundRobinPartitionMessageRouterImpl {
    private static final FunctionResultRouter INSTANCE = new FunctionResultRouter();

    public FunctionResultRouter() {
        this(Math.abs(ThreadLocalRandom.current().nextInt()), Clock.systemUTC());
    }

    @VisibleForTesting
    public FunctionResultRouter(int startPtnIdx, Clock clock) {
        super(HashingScheme.Murmur3_32Hash, startPtnIdx, true, 1L, clock);
    }

    public static FunctionResultRouter of() {
        return INSTANCE;
    }

    public int choosePartition(Message msg, TopicMetadata metadata) {
        if (msg.hasKey() || msg.getSequenceId() < 0L) {
            return super.choosePartition(msg, metadata);
        }
        return (int)(msg.getSequenceId() % (long)metadata.numPartitions());
    }
}

