/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result.ResultImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.KeyValue;

public class DeleteResultImpl<K, V>
extends ResultImpl<K, V, DeleteResultImpl<K, V>>
implements DeleteResult<K, V> {
    private List<KeyValue<K, V>> prevKvs = Collections.emptyList();
    private long numDeleted = 0L;

    DeleteResultImpl(Recycler.Handle<DeleteResultImpl<K, V>> handle) {
        super(OpType.DELETE, handle);
    }

    public DeleteResultImpl<K, V> prevKvs(List<KeyValue<K, V>> kvs) {
        this.prevKvs.forEach(KeyValue::close);
        this.prevKvs.clear();
        this.prevKvs = kvs;
        return this;
    }

    @Override
    public List<KeyValue<K, V>> getPrevKvsAndClear() {
        List<KeyValue<K, V>> prevKvsToReturn = this.prevKvs;
        this.prevKvs = Collections.emptyList();
        return prevKvsToReturn;
    }

    @Override
    protected void reset() {
        this.numDeleted = 0L;
        this.prevKvs.forEach(KeyValue::close);
        this.prevKvs = Collections.emptyList();
        super.reset();
    }

    @Override
    DeleteResultImpl<K, V> asResult() {
        return this;
    }

    public DeleteResultImpl<K, V> numDeleted(long numDeleted) {
        this.numDeleted = numDeleted;
        return this;
    }

    @Override
    public List<KeyValue<K, V>> prevKvs() {
        return this.prevKvs;
    }

    @Override
    public long numDeleted() {
        return this.numDeleted;
    }

    @Override
    public String toString() {
        return "DeleteResultImpl(prevKvs=" + this.prevKvs() + ", numDeleted=" + this.numDeleted() + ")";
    }
}

