/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.collect.Lists;
import org.apache.pulsar.functions.runtime.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.CallOptions;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Channel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientInterceptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientInterceptors;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Metadata;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.MethodDescriptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.stub.AbstractStub;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.stub.ClientCalls;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.PTable;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.Txn;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.op.OpFactoryImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result.KeyValueFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result.ResultFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.Op;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv.KvUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils.RetryUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.ListenableFutures;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TableServiceGrpc;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PByteBufSimpleTableImpl
extends AbstractStub<PByteBufSimpleTableImpl>
implements PTable<ByteBuf, ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(PByteBufSimpleTableImpl.class);
    private final OpFactory<ByteBuf, ByteBuf> opFactory;
    private final ResultFactory<ByteBuf, ByteBuf> resultFactory;
    private final KeyValueFactory<ByteBuf, ByteBuf> kvFactory;
    private final StreamProperties streamProps;
    private final long streamId;
    private final RetryUtils retryUtils;

    public PByteBufSimpleTableImpl(StreamProperties streamProps, Channel channel, CallOptions callOptions, RetryUtils retryUtils) {
        super(channel, callOptions);
        this.streamProps = streamProps;
        this.streamId = streamProps.getStreamId();
        this.opFactory = new OpFactoryImpl<ByteBuf, ByteBuf>();
        this.resultFactory = new ResultFactory();
        this.kvFactory = new KeyValueFactory();
        this.retryUtils = retryUtils;
    }

    private RoutingHeader.Builder newRoutingHeader(ByteBuf pKey) {
        return RoutingHeader.newBuilder().setStreamId(this.streamId).setRKey(UnsafeByteOperations.unsafeWrap(pKey.nioBuffer()));
    }

    private Channel getChannel(ByteBuf pKey) {
        RoutingHeaderInterceptor interceptor = new RoutingHeaderInterceptor(this.streamId, pKey);
        return ClientInterceptors.intercept((Channel)this.getChannel(), (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    @Override
    public CompletableFuture<RangeResult<ByteBuf, ByteBuf>> get(ByteBuf pKey, ByteBuf lKey, RangeOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        if (null != option.endKey()) {
            option.endKey().retain();
        }
        return ((CompletableFuture)this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(ClientCalls.futureUnaryCall((ClientCall)this.getChannel(pKey).newCall(TableServiceGrpc.getRangeMethod(), this.getCallOptions()), (Object)KvUtils.newRangeRequest(lKey, option).setHeader(this.newRoutingHeader(pKey)).build()))).thenApply(response -> KvUtils.newRangeResult(response, this.resultFactory, this.kvFactory))).whenComplete((value, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
            if (null != option.endKey()) {
                ReferenceCountUtil.release(option.endKey());
            }
        });
    }

    @Override
    public CompletableFuture<PutResult<ByteBuf, ByteBuf>> put(ByteBuf pKey, ByteBuf lKey, ByteBuf value, PutOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        value.retain();
        return ((CompletableFuture)this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(ClientCalls.futureUnaryCall((ClientCall)this.getChannel(pKey).newCall(TableServiceGrpc.getPutMethod(), this.getCallOptions()), (Object)KvUtils.newPutRequest(lKey, value, option).setHeader(this.newRoutingHeader(pKey)).build()))).thenApply(response -> KvUtils.newPutResult(response, this.resultFactory, this.kvFactory))).whenComplete((ignored, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
            ReferenceCountUtil.release(value);
        });
    }

    @Override
    public CompletableFuture<DeleteResult<ByteBuf, ByteBuf>> delete(ByteBuf pKey, ByteBuf lKey, DeleteOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        if (null != option.endKey()) {
            option.endKey().retain();
        }
        return ((CompletableFuture)this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(ClientCalls.futureUnaryCall((ClientCall)this.getChannel(pKey).newCall(TableServiceGrpc.getDeleteMethod(), this.getCallOptions()), (Object)KvUtils.newDeleteRequest(lKey, option).setHeader(this.newRoutingHeader(pKey)).build()))).thenApply(response -> KvUtils.newDeleteResult(response, this.resultFactory, this.kvFactory))).whenComplete((ignored, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
            if (null != option.endKey()) {
                ReferenceCountUtil.release(option.endKey());
            }
        });
    }

    @Override
    public CompletableFuture<IncrementResult<ByteBuf, ByteBuf>> increment(ByteBuf pKey, ByteBuf lKey, long amount, IncrementOption<ByteBuf> option) {
        pKey.retain();
        lKey.retain();
        return ((CompletableFuture)this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(ClientCalls.futureUnaryCall((ClientCall)this.getChannel(pKey).newCall(TableServiceGrpc.getIncrementMethod(), this.getCallOptions()), (Object)KvUtils.newIncrementRequest(lKey, amount, option).setHeader(this.newRoutingHeader(pKey)).build()))).thenApply(response -> KvUtils.newIncrementResult(response, this.resultFactory, this.kvFactory))).whenComplete((ignored, cause) -> {
            ReferenceCountUtil.release(pKey);
            ReferenceCountUtil.release(lKey);
        });
    }

    @Override
    public Txn<ByteBuf, ByteBuf> txn(ByteBuf pKey) {
        return new TxnImpl(pKey);
    }

    @Override
    public OpFactory<ByteBuf, ByteBuf> opFactory() {
        return this.opFactory;
    }

    @Override
    public void close() {
    }

    protected PByteBufSimpleTableImpl build(Channel channel, CallOptions callOptions) {
        return new PByteBufSimpleTableImpl(this.streamProps, channel, callOptions, this.retryUtils);
    }

    class TxnImpl
    implements Txn<ByteBuf, ByteBuf> {
        private final ByteBuf pKey;
        private final TxnRequest.Builder txnBuilder;
        private final List<AutoCloseable> resourcesToRelease;

        TxnImpl(ByteBuf pKey) {
            this.pKey = pKey.retain();
            this.txnBuilder = TxnRequest.newBuilder();
            this.resourcesToRelease = Lists.newArrayList();
        }

        @Override
        public Txn<ByteBuf, ByteBuf> If(CompareOp ... cmps) {
            for (CompareOp cmp : cmps) {
                this.txnBuilder.addCompare(KvUtils.toProtoCompare(cmp));
                this.resourcesToRelease.add(cmp);
            }
            return this;
        }

        @Override
        public Txn<ByteBuf, ByteBuf> Then(Op ... ops) {
            for (Op op : ops) {
                this.txnBuilder.addSuccess(KvUtils.toProtoRequest(op));
                this.resourcesToRelease.add(op);
            }
            return this;
        }

        @Override
        public Txn<ByteBuf, ByteBuf> Else(Op ... ops) {
            for (Op op : ops) {
                this.txnBuilder.addFailure(KvUtils.toProtoRequest(op));
                this.resourcesToRelease.add(op);
            }
            return this;
        }

        @Override
        public CompletableFuture<TxnResult<ByteBuf, ByteBuf>> commit() {
            return ((CompletableFuture)PByteBufSimpleTableImpl.this.retryUtils.execute(() -> ListenableFutures.fromListenableFuture(ClientCalls.futureUnaryCall((ClientCall)PByteBufSimpleTableImpl.this.getChannel(this.pKey).newCall(TableServiceGrpc.getTxnMethod(), PByteBufSimpleTableImpl.this.getCallOptions()), (Object)this.txnBuilder.setHeader(PByteBufSimpleTableImpl.this.newRoutingHeader(this.pKey)).build()))).thenApply(response -> KvUtils.newKvTxnResult(response, PByteBufSimpleTableImpl.this.resultFactory, PByteBufSimpleTableImpl.this.kvFactory))).whenComplete((ignored, cause) -> {
                ReferenceCountUtil.release(this.pKey);
                for (AutoCloseable resource : this.resourcesToRelease) {
                    this.closeResource(resource);
                }
            });
        }

        private void closeResource(AutoCloseable resource) {
            try {
                resource.close();
            }
            catch (Exception e) {
                log.warn("Fail to close resource {}", (Object)resource, (Object)e);
            }
        }
    }

    private static class RoutingHeaderInterceptor
    implements ClientInterceptor {
        private final long streamId;
        private final ByteBuf rKey;

        RoutingHeaderInterceptor(long streamId, ByteBuf rKey) {
            this.streamId = streamId;
            this.rKey = rKey;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                    headers.put(ProtocolConstants.SID_METADATA_KEY, (Object)streamId);
                    headers.put(ProtocolConstants.RK_METADATA_KEY, (Object)ByteBufUtil.getBytes(rKey));
                    this.delegate().start(responseListener, headers);
                }
            };
        }
    }
}

