/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.kv;

import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils.ListenableFutureRpcProcessor;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.stream.proto.storage.StatusCode;

class PutRequestProcessor<RespT>
extends ListenableFutureRpcProcessor<PutRequest, PutResponse, RespT> {
    private final PutRequest request;
    private final Function<PutResponse, RespT> responseFunc;

    public static <T> PutRequestProcessor<T> of(PutRequest request, Function<PutResponse, T> responseFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        return new PutRequestProcessor<T>(request, responseFunc, channel, executor, backoffPolicy);
    }

    private PutRequestProcessor(PutRequest request, Function<PutResponse, RespT> respFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        super(channel, executor, backoffPolicy);
        this.request = request;
        this.responseFunc = respFunc;
    }

    @Override
    protected PutRequest createRequest() {
        return this.request;
    }

    @Override
    protected ListenableFuture<PutResponse> sendRPC(StorageServerChannel rsChannel, PutRequest request) {
        return rsChannel.getTableService().put(request);
    }

    @Override
    protected RespT processResponse(PutResponse response) throws Exception {
        if (StatusCode.SUCCESS == response.getHeader().getCode()) {
            return this.responseFunc.apply(response);
        }
        throw new InternalServerException("Encountered internal server exception : code = " + response.getHeader().getCode());
    }
}

