/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.clients.utils;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Status;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.StatusException;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.StatusRuntimeException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.ListenableFutures;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.Retries;

public class RetryUtils {
    @VisibleForTesting
    static final Predicate<Throwable> DEFAULT_CLIENT_RETRY_PREDICATE = cause -> RetryUtils.shouldRetryOnException(cause);
    private final Predicate<Throwable> retryPredicate;
    private final Backoff.Policy backoffPolicy;
    private final OrderedScheduler scheduler;

    private static boolean shouldRetryOnException(Throwable cause) {
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            Status status = cause instanceof StatusException ? ((StatusException)cause).getStatus() : ((StatusRuntimeException)cause).getStatus();
            switch (status.getCode()) {
                case INVALID_ARGUMENT: 
                case ALREADY_EXISTS: 
                case PERMISSION_DENIED: 
                case UNAUTHENTICATED: {
                    return false;
                }
            }
            return true;
        }
        if (cause instanceof RuntimeException) {
            return false;
        }
        return false;
    }

    public static RetryUtils create(Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        return RetryUtils.create(DEFAULT_CLIENT_RETRY_PREDICATE, backoffPolicy, scheduler);
    }

    public static RetryUtils create(Predicate<Throwable> retryPredicate, Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        return new RetryUtils(retryPredicate, backoffPolicy, scheduler);
    }

    private RetryUtils(Predicate<Throwable> retryPredicate, Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        this.retryPredicate = retryPredicate;
        this.backoffPolicy = backoffPolicy;
        this.scheduler = scheduler;
    }

    public <T> CompletableFuture<T> execute(Supplier<CompletableFuture<T>> action) {
        return Retries.run(this.backoffPolicy.toBackoffs(), this.retryPredicate, action, this.scheduler);
    }

    public <T> CompletableFuture<T> executeListenable(Supplier<ListenableFuture<T>> action) {
        return Retries.run(this.backoffPolicy.toBackoffs(), this.retryPredicate, () -> ListenableFutures.fromListenableFuture((ListenableFuture)action.get()), this.scheduler);
    }
}

