/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.bookies;

import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceIdCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(InstanceIdCommand.class);
    private static final String NAME = "instanceid";
    private static final String DESC = "Print the instanceid of the cluster";

    public InstanceIdCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            MetadataDrivers.runFunctionWithRegistrationManager(conf, rm -> {
                String readInstanceId = null;
                try {
                    readInstanceId = rm.getClusterInstanceId();
                }
                catch (BookieException e) {
                    throw new UncheckedExecutionException(e);
                }
                LOG.info("Metadata Service Uri: {} InstanceId: {}", (Object)conf.getMetadataServiceUriUnchecked(), (Object)readInstanceId);
                return null;
            });
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
        return true;
    }
}

