/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.bootstrap.ServerBootstrap;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.Channel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SocketAddress;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.SocketAddressImpl;

public class AsyncResolveConnectHelper {
    public static org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.Future<Channel> doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        Promise promise = vertx.getAcceptorEventLoopGroup().next().newPromise();
        try {
            bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.isDomainSocket()));
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return promise;
        }
        if (socketAddress.isDomainSocket()) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress);
            ChannelFuture future = bootstrap.bind(converted);
            future.addListener(f -> {
                if (f.isSuccess()) {
                    promise.setSuccess((Object)future.channel());
                } else {
                    promise.setFailure(f.cause());
                }
            });
        } else {
            SocketAddressImpl impl = (SocketAddressImpl)socketAddress;
            Handler<AsyncResult<InetAddress>> cont = res -> {
                if (res.succeeded()) {
                    InetSocketAddress t = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future = bootstrap.bind((java.net.SocketAddress)t);
                    future.addListener(f -> {
                        if (f.isSuccess()) {
                            promise.setSuccess((Object)future.channel());
                        } else {
                            promise.setFailure(f.cause());
                        }
                    });
                } else {
                    promise.setFailure(res.cause());
                }
            };
            if (impl.ipAddress() != null) {
                cont.handle(Future.succeededFuture(impl.ipAddress()));
            } else {
                vertx.resolveAddress(socketAddress.host(), cont);
            }
        }
        return promise;
    }
}

