/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.grpc;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Metadata;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerCall;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerCallHandler;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ServerInterceptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.Status;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Vertx;

public class BlockingServerInterceptor
implements ServerInterceptor {
    private final Vertx vertx;
    private final ServerInterceptor interceptor;

    public static ServerInterceptor wrap(Vertx vertx, ServerInterceptor interceptor) {
        return new BlockingServerInterceptor(vertx, interceptor);
    }

    private BlockingServerInterceptor(Vertx vertx, ServerInterceptor interceptor) {
        this.vertx = vertx;
        this.interceptor = interceptor;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        AsyncListener asyncListener = new AsyncListener();
        this.vertx.executeBlocking(blockingCode -> blockingCode.complete(this.interceptor.interceptCall(serverCall, metadata, serverCallHandler)), false, ar -> {
            if (ar.succeeded()) {
                asyncListener.setDelegate((ServerCall.Listener)ar.result());
            } else {
                Metadata md = Status.trailersFromThrowable((Throwable)ar.cause());
                if (md == null) {
                    md = new Metadata();
                }
                serverCall.close(Status.fromThrowable((Throwable)ar.cause()), md);
            }
        });
        return asyncListener;
    }

    private static class AsyncListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private ServerCall.Listener<ReqT> delegate;
        private final List<Consumer<ServerCall.Listener<ReqT>>> incomingEvents = new LinkedList<Consumer<ServerCall.Listener<ReqT>>>();

        private AsyncListener() {
        }

        void setDelegate(ServerCall.Listener<ReqT> delegate) {
            this.delegate = delegate;
            for (Consumer<ServerCall.Listener<ReqT>> event : this.incomingEvents) {
                event.accept(delegate);
            }
            this.incomingEvents.clear();
        }

        private void runIfPresent(Consumer<ServerCall.Listener<ReqT>> consumer) {
            if (this.delegate != null) {
                consumer.accept(this.delegate);
            } else {
                this.incomingEvents.add(consumer);
            }
        }

        public void onMessage(ReqT message) {
            this.runIfPresent(t -> t.onMessage(message));
        }

        public void onHalfClose() {
            this.runIfPresent(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.runIfPresent(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.runIfPresent(ServerCall.Listener::onComplete);
        }

        public void onReady() {
            this.runIfPresent(ServerCall.Listener::onReady);
        }
    }
}

