/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Joiner;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResources<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseResources.class);
    protected static final String BASE_POLICIES_PATH = "/admin/policies";
    protected static final String BASE_CLUSTERS_PATH = "/admin/clusters";
    protected static final String LOCAL_POLICIES_ROOT = "/admin/local-policies";
    private final MetadataStore store;
    private final MetadataCache<T> cache;
    private int operationTimeoutSec;

    public BaseResources(MetadataStore store, Class<T> clazz, int operationTimeoutSec) {
        this.store = store;
        this.cache = store.getMetadataCache(clazz);
        this.operationTimeoutSec = operationTimeoutSec;
    }

    public BaseResources(MetadataStore store, TypeReference<T> typeRef, int operationTimeoutSec) {
        this.store = store;
        this.cache = store.getMetadataCache(typeRef);
        this.operationTimeoutSec = operationTimeoutSec;
    }

    protected List<String> getChildren(String path) throws MetadataStoreException {
        try {
            return this.getChildrenAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to get children of " + path, e);
        }
    }

    protected CompletableFuture<List<String>> getChildrenAsync(String path) {
        return this.cache.getChildren(path);
    }

    protected CompletableFuture<List<String>> getChildrenRecursiveAsync(String path) {
        ConcurrentHashMap.KeySetView children = ConcurrentHashMap.newKeySet();
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        this.getChildrenRecursiveAsync(path, children, result, new AtomicInteger(1), path);
        return result;
    }

    private void getChildrenRecursiveAsync(String path, Set<String> children, CompletableFuture<List<String>> result, AtomicInteger totalResults, String parent) {
        this.cache.getChildren(path).thenAccept(childList -> {
            List<Object> list = childList = childList != null ? childList : Collections.emptyList();
            if (totalResults.decrementAndGet() == 0 && childList.isEmpty()) {
                result.complete(new ArrayList(children));
                return;
            }
            if (childList.isEmpty()) {
                return;
            }
            children.remove(parent);
            Object childPrefix = path.equals(parent) ? "" : parent + "/";
            totalResults.addAndGet(childList.size());
            for (String child : childList) {
                children.add((String)childPrefix + child);
                String childPath = path + "/" + child;
                this.getChildrenRecursiveAsync(childPath, children, result, totalResults, child);
            }
        });
    }

    protected Optional<T> get(String path) throws MetadataStoreException {
        try {
            return this.getAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to get data from " + path, e);
        }
    }

    protected CompletableFuture<Optional<T>> getAsync(String path) {
        return this.cache.get(path);
    }

    protected CompletableFuture<Optional<T>> refreshAndGetAsync(String path) {
        return this.store.sync(path).thenCompose(___ -> {
            this.cache.invalidate(path);
            return this.cache.get(path);
        });
    }

    protected void set(String path, Function<T, T> modifyFunction) throws MetadataStoreException {
        try {
            this.setAsync(path, modifyFunction).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to set data for " + path, e);
        }
    }

    protected CompletableFuture<Void> setAsync(String path, Function<T, T> modifyFunction) {
        return this.cache.readModifyUpdate(path, modifyFunction).thenApply(__ -> null);
    }

    protected void setWithCreate(String path, Function<Optional<T>, T> createFunction) throws MetadataStoreException {
        try {
            this.setWithCreateAsync(path, createFunction).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to set/create " + path, e);
        }
    }

    protected CompletableFuture<Void> setWithCreateAsync(String path, Function<Optional<T>, T> createFunction) {
        return this.cache.readModifyUpdateOrCreate(path, createFunction).thenApply(__ -> null);
    }

    protected void create(String path, T data) throws MetadataStoreException {
        try {
            this.createAsync(path, data).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to create " + path, e);
        }
    }

    protected CompletableFuture<Void> createAsync(String path, T data) {
        return this.cache.create(path, data);
    }

    protected void delete(String path) throws MetadataStoreException {
        try {
            this.deleteAsync(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to delete " + path, e);
        }
    }

    protected CompletableFuture<Void> deleteAsync(String path) {
        return this.cache.delete(path);
    }

    protected CompletableFuture<Void> deleteIfExistsAsync(String path) {
        return this.cache.exists(path).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture future = new CompletableFuture();
            this.cache.delete(path).whenComplete((ignore, ex) -> {
                if (ex != null && ex.getCause() instanceof MetadataStoreException.NotFoundException) {
                    future.complete(null);
                } else if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                } else {
                    future.complete(null);
                }
            });
            return future;
        });
    }

    protected boolean exists(String path) throws MetadataStoreException {
        try {
            return this.cache.exists(path).get(this.operationTimeoutSec, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof MetadataStoreException ? (MetadataStoreException)e.getCause() : new MetadataStoreException(e.getCause());
        }
        catch (Exception e) {
            throw new MetadataStoreException("Failed to check exist " + path, e);
        }
    }

    protected CompletableFuture<Boolean> existsAsync(String path) {
        return this.cache.exists(path);
    }

    public int getOperationTimeoutSec() {
        return this.operationTimeoutSec;
    }

    protected static String joinPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        Joiner.on('/').appendTo(sb, (Object[])parts);
        return sb.toString();
    }

    public MetadataStore getStore() {
        return this.store;
    }

    public MetadataCache<T> getCache() {
        return this.cache;
    }
}

