/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.FailureDomainImpl;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;

public class ClusterResources
extends BaseResources<ClusterData> {
    private FailureDomainResources failureDomainResources;

    public ClusterResources(MetadataStore store, int operationTimeoutSec) {
        super(store, ClusterData.class, operationTimeoutSec);
        this.failureDomainResources = new FailureDomainResources(store, FailureDomainImpl.class, operationTimeoutSec);
    }

    public CompletableFuture<Set<String>> listAsync() {
        return this.getChildrenAsync("/admin/clusters").thenApply(HashSet::new);
    }

    public Set<String> list() throws MetadataStoreException {
        return new HashSet<String>(super.getChildren("/admin/clusters"));
    }

    public Optional<ClusterData> getCluster(String clusterName) throws MetadataStoreException {
        return this.get(ClusterResources.joinPath("/admin/clusters", clusterName));
    }

    public CompletableFuture<Optional<ClusterData>> getClusterAsync(String clusterName) {
        return this.getAsync(ClusterResources.joinPath("/admin/clusters", clusterName));
    }

    public List<String> getNamespacesForCluster(String tenant, String clusterName) throws MetadataStoreException {
        return this.getChildren(ClusterResources.joinPath("/admin/policies", tenant, clusterName));
    }

    public void createCluster(String clusterName, ClusterData clusterData) throws MetadataStoreException {
        this.create(ClusterResources.joinPath("/admin/clusters", clusterName), clusterData);
    }

    public CompletableFuture<Void> createClusterAsync(String clusterName, ClusterData clusterData) {
        return this.createAsync(ClusterResources.joinPath("/admin/clusters", clusterName), clusterData);
    }

    public CompletableFuture<Void> updateClusterAsync(String clusterName, Function<ClusterData, ClusterData> modifyFunction) {
        return this.setAsync(ClusterResources.joinPath("/admin/clusters", clusterName), modifyFunction);
    }

    public void updateCluster(String clusterName, Function<ClusterData, ClusterData> modifyFunction) throws MetadataStoreException {
        this.set(ClusterResources.joinPath("/admin/clusters", clusterName), modifyFunction);
    }

    public void deleteCluster(String clusterName) throws MetadataStoreException {
        this.delete(ClusterResources.joinPath("/admin/clusters", clusterName));
    }

    public CompletableFuture<Void> deleteClusterAsync(String clusterName) {
        return this.deleteAsync(ClusterResources.joinPath("/admin/clusters", clusterName));
    }

    public CompletableFuture<Boolean> isClusterUsedAsync(String clusterName) {
        return this.getCache().getChildren("/admin/policies").thenCompose(tenants -> {
            List futures = tenants.stream().map(tenant -> this.getCache().getChildren(ClusterResources.joinPath("/admin/policies", tenant, clusterName))).collect(Collectors.toList());
            return FutureUtil.waitForAll(futures).thenApply(__ -> futures.stream().map(CompletableFuture::join).anyMatch(CollectionUtils::isNotEmpty));
        });
    }

    public boolean isClusterUsed(String clusterName) throws MetadataStoreException {
        for (String tenant : this.getCache().getChildren("/admin/policies").join()) {
            if (this.getCache().getChildren(ClusterResources.joinPath("/admin/policies", tenant, clusterName)).join().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean clusterExists(String clusterName) throws MetadataStoreException {
        return this.exists(ClusterResources.joinPath("/admin/clusters", clusterName));
    }

    public CompletableFuture<Boolean> clusterExistsAsync(String clusterName) {
        return this.getCache().exists(ClusterResources.joinPath("/admin/clusters", clusterName));
    }

    public static boolean pathRepresentsClusterName(String path) {
        return path.startsWith("/admin/clusters");
    }

    public static String clusterNameFromPath(String path) {
        return path.substring("/admin/clusters".length() + 1);
    }

    public FailureDomainResources getFailureDomainResources() {
        return this.failureDomainResources;
    }

    public static class FailureDomainResources
    extends BaseResources<FailureDomainImpl> {
        public static final String FAILURE_DOMAIN = "failureDomain";

        public FailureDomainResources(MetadataStore store, Class<FailureDomainImpl> clazz, int operationTimeoutSec) {
            super(store, clazz, operationTimeoutSec);
        }

        public CompletableFuture<List<String>> listFailureDomainsAsync(String clusterName) {
            return this.getChildrenAsync(FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN));
        }

        public List<String> listFailureDomains(String clusterName) throws MetadataStoreException {
            return this.getChildren(FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN));
        }

        public CompletableFuture<Optional<FailureDomainImpl>> getFailureDomainAsync(String clusterName, String domainName) {
            return this.getAsync(FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN, domainName));
        }

        public Optional<FailureDomainImpl> getFailureDomain(String clusterName, String domainName) throws MetadataStoreException {
            return this.get(FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN, domainName));
        }

        public void deleteFailureDomain(String clusterName, String domainName) throws MetadataStoreException {
            String path = FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN, domainName);
            this.delete(path);
        }

        public CompletableFuture<Void> deleteFailureDomainAsync(String clusterName, String domainName) {
            String path = FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN, domainName);
            return this.deleteAsync(path);
        }

        public CompletableFuture<Void> deleteFailureDomainsAsync(String clusterName) {
            String failureDomainPath = FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN);
            return this.existsAsync(failureDomainPath).thenCompose(exists -> {
                if (!exists.booleanValue()) {
                    return CompletableFuture.completedFuture(null);
                }
                return ((CompletableFuture)this.getChildrenAsync(failureDomainPath).thenCompose(children -> FutureUtil.waitForAll(children.stream().map(domain -> this.deleteAsync(FailureDomainResources.joinPath(failureDomainPath, domain))).collect(Collectors.toList())))).thenCompose(__ -> this.deleteAsync(failureDomainPath));
            });
        }

        public void deleteFailureDomains(String clusterName) throws MetadataStoreException {
            String failureDomainPath = FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN);
            if (!this.exists(failureDomainPath)) {
                return;
            }
            for (String domain : this.getChildren(failureDomainPath)) {
                this.delete(FailureDomainResources.joinPath(failureDomainPath, domain));
            }
            this.delete(failureDomainPath);
        }

        public CompletableFuture<Void> setFailureDomainWithCreateAsync(String clusterName, String domainName, Function<Optional<FailureDomainImpl>, FailureDomainImpl> createFunction) {
            return this.setWithCreateAsync(FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN, domainName), createFunction);
        }

        public void setFailureDomainWithCreate(String clusterName, String domainName, Function<Optional<FailureDomainImpl>, FailureDomainImpl> createFunction) throws MetadataStoreException {
            this.setWithCreate(FailureDomainResources.joinPath("/admin/clusters", clusterName, FAILURE_DOMAIN, domainName), createFunction);
        }

        public void registerListener(Consumer<Notification> listener) {
            this.getStore().registerListener(n -> {
                if (n.getPath().startsWith("/admin/clusters") && n.getPath().contains("/failureDomain")) {
                    listener.accept((Notification)n);
                }
            });
        }
    }
}

