/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.Filter;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.FilterChain;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.FilterConfig;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletException;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletRequest;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.ServletResponse;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.functions.runtime.shaded.javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final AuthenticationService authenticationService;
    public static final String AuthenticatedRoleAttributeName = AuthenticationFilter.class.getName() + "-role";
    public static final String AuthenticatedDataAttributeName = AuthenticationFilter.class.getName() + "-data";
    public static final String PULSAR_AUTH_METHOD_NAME = "X-Pulsar-Auth-Method-Name";

    public AuthenticationFilter(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean doFilter;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            doFilter = this.authenticationService.authenticateHttpRequest(httpRequest, httpResponse);
        }
        catch (Exception e) {
            httpResponse.sendError(401, "Authentication required");
            if (e instanceof AuthenticationException) {
                LOG.warn("[{}] Failed to authenticate HTTP request: {}", (Object)request.getRemoteAddr(), (Object)e.getMessage());
            } else {
                LOG.error("[{}] Error performing authentication for HTTP", (Object)request.getRemoteAddr(), (Object)e);
            }
            return;
        }
        if (doFilter) {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void init(FilterConfig arg) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

