/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBookieAddressResolver
implements BookieAddressResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultBookieAddressResolver.class);
    private final RegistrationClient registrationClient;

    public DefaultBookieAddressResolver(RegistrationClient registrationClient) {
        this.registrationClient = registrationClient;
    }

    public RegistrationClient getRegistrationClient() {
        return this.registrationClient;
    }

    @Override
    public BookieSocketAddress resolve(BookieId bookieId) {
        try {
            BookieServiceInfo info = FutureUtils.result(this.registrationClient.getBookieServiceInfo(bookieId)).getValue();
            BookieServiceInfo.Endpoint endpoint = info.getEndpoints().stream().filter(e -> e.getProtocol().equals("bookie-rpc")).findAny().orElse(null);
            if (endpoint == null) {
                throw new Exception("bookie " + bookieId + " does not publish a bookie-rpc endpoint");
            }
            BookieSocketAddress res = new BookieSocketAddress(endpoint.getHost(), endpoint.getPort());
            if (!bookieId.toString().equals(res.toString())) {
                log.info("Resolved {} as {}", (Object)bookieId, (Object)res);
            } else if (log.isDebugEnabled()) {
                log.debug("Resolved {} as {}", (Object)bookieId, (Object)res);
            }
            return res;
        }
        catch (BKException.BKBookieHandleNotAvailableException ex) {
            if (BookieSocketAddress.isDummyBookieIdForHostname(bookieId)) {
                if (log.isDebugEnabled()) {
                    log.debug("Resolving dummy bookie Id {} using legacy bookie resolver", (Object)bookieId);
                }
                return BookieSocketAddress.resolveLegacyBookieId(bookieId);
            }
            log.info("Cannot resolve {}, bookie is unknown {}", (Object)bookieId, (Object)ex.toString());
            throw new BookieAddressResolver.BookieIdNotResolvedException(bookieId, (Throwable)ex);
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new BookieAddressResolver.BookieIdNotResolvedException(bookieId, (Throwable)ex);
        }
    }
}

