/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.zookeeper.common;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.Epoll;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.pulsar.functions.runtime.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUtils.class);
    private static final int DEFAULT_INET_ADDRESS_COUNT = 1;

    public static EventLoopGroup newNioOrEpollEventLoopGroup() {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup();
        }
        return new NioEventLoopGroup();
    }

    public static EventLoopGroup newNioOrEpollEventLoopGroup(int nThreads) {
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(nThreads);
        }
        return new NioEventLoopGroup(nThreads);
    }

    public static Class<? extends SocketChannel> nioOrEpollSocketChannel() {
        if (Epoll.isAvailable()) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> nioOrEpollServerSocketChannel() {
        if (Epoll.isAvailable()) {
            return EpollServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public static int getClientReachableLocalInetAddressCount() {
        try {
            HashSet<InetAddress> validInetAddresses = new HashSet<InetAddress>();
            Enumeration<NetworkInterface> allNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(allNetworkInterfaces)) {
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    if (inetAddress.isLinkLocalAddress()) {
                        LOG.debug("Ignoring link-local InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    if (inetAddress.isMulticastAddress()) {
                        LOG.debug("Ignoring multicast InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    if (inetAddress.isLoopbackAddress()) {
                        LOG.debug("Ignoring loopback InetAddress {}", (Object)inetAddress);
                        continue;
                    }
                    validInetAddresses.add(inetAddress);
                }
            }
            LOG.debug("Detected {} local network addresses: {}", (Object)validInetAddresses.size(), validInetAddresses);
            return validInetAddresses.size() > 0 ? validInetAddresses.size() : 1;
        }
        catch (SocketException ex) {
            LOG.warn("Failed to list all network interfaces, assuming 1", (Throwable)ex);
            return 1;
        }
    }
}

