/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.stats;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Gauge;
import org.apache.pulsar.functions.runtime.shaded.io.prometheus.client.Histogram;

public final class BatchMetadataStoreStats
implements AutoCloseable {
    private static final double[] BUCKETS = new double[]{1.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0};
    private static final String NAME = "name";
    private static final Gauge EXECUTOR_QUEUE_SIZE = (Gauge)((Gauge.Builder)Gauge.build("pulsar_batch_metadata_store_executor_queue_size", "-").labelNames("name")).register();
    private static final Histogram OPS_WAITING = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build("pulsar_batch_metadata_store_queue_wait_time", "-").unit("ms")).labelNames("name")).buckets(BUCKETS).register();
    private static final Histogram BATCH_EXECUTE_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build("pulsar_batch_metadata_store_batch_execute_time", "-").unit("ms")).labelNames("name")).buckets(BUCKETS).register();
    private static final Histogram OPS_PER_BATCH = (Histogram)((Histogram.Builder)Histogram.build("pulsar_batch_metadata_store_batch_size", "-").labelNames("name")).buckets(BUCKETS).register();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ThreadPoolExecutor executor;
    private final String metadataStoreName;
    private final Histogram.Child batchOpsWaitingChild;
    private final Histogram.Child batchExecuteTimeChild;
    private final Histogram.Child opsPerBatchChild;

    public BatchMetadataStoreStats(String metadataStoreName, ExecutorService executor) {
        ThreadPoolExecutor tx;
        this.executor = executor instanceof ThreadPoolExecutor ? (tx = (ThreadPoolExecutor)executor) : null;
        this.metadataStoreName = metadataStoreName;
        EXECUTOR_QUEUE_SIZE.setChild(new Gauge.Child(){

            @Override
            public double get() {
                return BatchMetadataStoreStats.this.executor == null ? 0.0 : (double)BatchMetadataStoreStats.this.executor.getQueue().size();
            }
        }, metadataStoreName);
        this.batchOpsWaitingChild = (Histogram.Child)OPS_WAITING.labels(metadataStoreName);
        this.batchExecuteTimeChild = (Histogram.Child)BATCH_EXECUTE_TIME.labels(metadataStoreName);
        this.opsPerBatchChild = (Histogram.Child)OPS_PER_BATCH.labels(metadataStoreName);
    }

    public void recordOpWaiting(long millis) {
        this.batchOpsWaitingChild.observe(millis);
    }

    public void recordBatchExecuteTime(long millis) {
        this.batchExecuteTimeChild.observe(millis);
    }

    public void recordOpsInBatch(int ops) {
        this.opsPerBatchChild.observe(ops);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            EXECUTOR_QUEUE_SIZE.remove(this.metadataStoreName);
            OPS_WAITING.remove(this.metadataStoreName);
            BATCH_EXECUTE_TIME.remove(this.metadataStoreName);
            OPS_PER_BATCH.remove(this.metadataStoreName);
        }
    }
}

