/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public final class MessageResolver
implements EventResolver {
    private static final String[] FORMATS = new String[]{"JSON"};
    private final EventResolver internalResolver;

    MessageResolver(TemplateResolverConfig config) {
        this.internalResolver = MessageResolver.createInternalResolver(config);
    }

    static String getName() {
        return "message";
    }

    private static EventResolver createInternalResolver(TemplateResolverConfig config) {
        boolean stringified = config.getBoolean("stringified", false);
        String fallbackKey = config.getString("fallbackKey");
        if (stringified && fallbackKey != null) {
            throw new IllegalArgumentException("fallbackKey is not allowed when stringified is enable: " + config);
        }
        return stringified ? MessageResolver.createStringResolver(fallbackKey) : MessageResolver.createObjectResolver(fallbackKey);
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    private static EventResolver createStringResolver(String fallbackKey) {
        return (logEvent, jsonWriter) -> MessageResolver.resolveString(fallbackKey, logEvent, jsonWriter);
    }

    private static void resolveString(String fallbackKey, LogEvent logEvent, JsonWriter jsonWriter) {
        Message message = logEvent.getMessage();
        MessageResolver.resolveString(fallbackKey, message, jsonWriter);
    }

    private static void resolveString(String fallbackKey, Message message, JsonWriter jsonWriter) {
        if (fallbackKey != null) {
            jsonWriter.writeObjectStart();
            jsonWriter.writeObjectKey(fallbackKey);
        }
        if (message instanceof CharSequence) {
            jsonWriter.writeString((CharSequence)((Object)message));
        } else if (message instanceof StringBuilderFormattable) {
            jsonWriter.writeString((StringBuilderFormattable)((Object)message));
        } else {
            String formattedMessage = message.getFormattedMessage();
            jsonWriter.writeString(formattedMessage);
        }
        if (fallbackKey != null) {
            jsonWriter.writeObjectEnd();
        }
    }

    private static EventResolver createObjectResolver(String fallbackKey) {
        return (logEvent, jsonWriter) -> {
            Message message = logEvent.getMessage();
            boolean simple = message instanceof SimpleMessage;
            if (!simple) {
                if (MessageResolver.writeMultiformatMessage(jsonWriter, message)) {
                    return;
                }
                if (MessageResolver.writeObjectMessage(jsonWriter, message)) {
                    return;
                }
            }
            MessageResolver.resolveString(fallbackKey, logEvent, jsonWriter);
        };
    }

    private static boolean writeMultiformatMessage(JsonWriter jsonWriter, Message message) {
        String[] formats;
        if (!(message instanceof MultiformatMessage)) {
            return false;
        }
        MultiformatMessage multiformatMessage = (MultiformatMessage)message;
        boolean jsonSupported = false;
        for (String format : formats = multiformatMessage.getFormats()) {
            if (!FORMATS[0].equalsIgnoreCase(format)) continue;
            jsonSupported = true;
            break;
        }
        if (!jsonSupported) {
            return false;
        }
        String messageJson = multiformatMessage.getFormattedMessage(FORMATS);
        jsonWriter.writeRawString(messageJson);
        return true;
    }

    private static boolean writeObjectMessage(JsonWriter jsonWriter, Message message) {
        if (!(message instanceof ObjectMessage)) {
            return false;
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        Object object = objectMessage.getParameter();
        jsonWriter.writeValue(object);
        return true;
    }
}

