/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.batchdatagenerator;

import io.codearte.jfairy.Fairy;
import io.codearte.jfairy.producer.person.PersonProperties;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.batchdatagenerator.Person;
import org.apache.pulsar.io.core.BatchSource;
import org.apache.pulsar.io.core.SourceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDataGeneratorSource
implements BatchSource<Person> {
    private static final Logger log = LoggerFactory.getLogger(BatchDataGeneratorSource.class);
    private Fairy fairy;
    private SourceContext sourceContext;
    int iteration;
    int maxRecordsPerCycle = 10;

    public void open(Map<String, Object> config, SourceContext sourceContext) {
        this.fairy = Fairy.create();
        this.sourceContext = sourceContext;
    }

    public void discover(Consumer<byte[]> taskEater) {
        log.info("Generating one task for each instance");
        for (int i = 0; i < this.sourceContext.getNumInstances(); ++i) {
            taskEater.accept("something".getBytes(StandardCharsets.UTF_8));
        }
    }

    public void prepare(byte[] instanceSplit) {
        log.info("Instance " + this.sourceContext.getInstanceId() + " got a new discovered task");
        String str = new String(instanceSplit, StandardCharsets.UTF_8);
        String expected = "something";
        assert (str.equals("something"));
        this.iteration = 0;
    }

    public Record<Person> readNext() throws Exception {
        if (this.iteration++ < this.maxRecordsPerCycle) {
            Thread.sleep(50L);
            return new Record<Person>(){

                public Optional<String> getKey() {
                    return Optional.empty();
                }

                public Person getValue() {
                    return new Person(BatchDataGeneratorSource.this.fairy.person(new PersonProperties.PersonProperty[0]));
                }
            };
        }
        return null;
    }

    public void close() {
    }
}

