/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.dynamodb;

import com.amazonaws.services.dynamodbv2.streamsadapter.model.RecordAdapter;
import com.amazonaws.services.kinesis.model.Record;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.utils.StringUtils;

public class StreamsRecord
implements org.apache.pulsar.functions.api.Record<byte[]> {
    public static final String ARRIVAL_TIMESTAMP = "ARRIVAL_TIMESTAMP";
    public static final String ENCRYPTION_TYPE = "ENCRYPTION_TYPE";
    public static final String PARTITION_KEY = "PARTITION_KEY";
    public static final String SEQUENCE_NUMBER = "SEQUENCE_NUMBER";
    public static final String EVENT_NAME = "EVENT_NAME";
    private static final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private final Optional<String> key;
    private final byte[] value;
    private final Map<String, String> properties = new HashMap<String, String>();

    public StreamsRecord(Record record) {
        if (record instanceof RecordAdapter) {
            com.amazonaws.services.dynamodbv2.model.Record dynamoRecord = ((RecordAdapter)record).getInternalObject();
            this.key = Optional.of(dynamoRecord.getEventID());
            this.setProperty(EVENT_NAME, dynamoRecord.getEventName());
            this.setProperty(SEQUENCE_NUMBER, dynamoRecord.getDynamodb().getSequenceNumber());
        } else {
            this.key = Optional.of(record.getPartitionKey());
            this.setProperty(ARRIVAL_TIMESTAMP, record.getApproximateArrivalTimestamp().toString());
            this.setProperty(ENCRYPTION_TYPE, record.getEncryptionType());
            this.setProperty(PARTITION_KEY, record.getPartitionKey());
            this.setProperty(SEQUENCE_NUMBER, record.getSequenceNumber());
        }
        if (StringUtils.isBlank((CharSequence)record.getEncryptionType())) {
            String s = null;
            try {
                s = decoder.decode(record.getData()).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
            this.value = s != null ? s.getBytes() : null;
        } else {
            this.value = null;
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

