/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.flume;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.flume.util.SSLUtil;
import org.apache.pulsar.io.flume.FlumeConfig;
import org.apache.pulsar.io.flume.node.Application;
import org.apache.pulsar.io.flume.node.PollingPropertiesFileConfigurationProvider;
import org.apache.pulsar.io.flume.node.PollingZooKeeperConfigurationProvider;
import org.apache.pulsar.io.flume.node.PropertiesFileConfigurationProvider;
import org.apache.pulsar.io.flume.node.StaticZooKeeperConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeConnector {
    private static final Logger log = LoggerFactory.getLogger(FlumeConnector.class);
    protected Application application;

    public void StartConnector(FlumeConfig flumeConfig) throws Exception {
        SSLUtil.initGlobalSSLParameters();
        String agentName = flumeConfig.getName();
        boolean reload = flumeConfig.getNoReloadConf() == false;
        boolean isZkConfigured = false;
        if (flumeConfig.getZkConnString().length() > 0) {
            isZkConfigured = true;
        }
        if (isZkConfigured) {
            String zkConnectionStr = flumeConfig.getZkConnString();
            String baseZkPath = flumeConfig.getZkBasePath();
            if (reload) {
                EventBus eventBus = new EventBus(agentName + "-event-bus");
                ArrayList components = Lists.newArrayList();
                PollingZooKeeperConfigurationProvider zookeeperConfigurationProvider = new PollingZooKeeperConfigurationProvider(agentName, zkConnectionStr, baseZkPath, eventBus);
                components.add(zookeeperConfigurationProvider);
                this.application = new Application(components);
                eventBus.register((Object)this.application);
            } else {
                StaticZooKeeperConfigurationProvider zookeeperConfigurationProvider = new StaticZooKeeperConfigurationProvider(agentName, zkConnectionStr, baseZkPath);
                this.application = new Application();
                this.application.handleConfigurationEvent(zookeeperConfigurationProvider.getConfiguration());
            }
        } else {
            File configurationFile = new File(flumeConfig.getConfFile());
            if (!configurationFile.exists() && System.getProperty("flume.called.from.service") == null) {
                String path = configurationFile.getPath();
                try {
                    path = configurationFile.getCanonicalPath();
                }
                catch (IOException ex) {
                    log.error("Failed to read canonical path for file: " + path, (Throwable)ex);
                }
                throw new ParseException("The specified configuration file does not exist: " + path);
            }
            ArrayList components = Lists.newArrayList();
            if (reload) {
                EventBus eventBus = new EventBus(agentName + "-event-bus");
                PollingPropertiesFileConfigurationProvider configurationProvider = new PollingPropertiesFileConfigurationProvider(agentName, configurationFile, eventBus, 30);
                components.add(configurationProvider);
                this.application = new Application(components);
                eventBus.register((Object)this.application);
            } else {
                PropertiesFileConfigurationProvider configurationProvider = new PropertiesFileConfigurationProvider(agentName, configurationFile);
                this.application = new Application();
                this.application.handleConfigurationEvent(configurationProvider.getConfiguration());
            }
        }
        this.application.start();
        final Application appReference = this.application;
        Runtime.getRuntime().addShutdownHook(new Thread("agent-shutdown-hook"){

            @Override
            public void run() {
                appReference.stop();
            }
        });
    }

    public void stop() {
        if (this.application != null) {
            this.application.stop();
        }
    }
}

