/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hdfs2.sink;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.io.hdfs2.AbstractHdfsConfig;

public class HdfsSinkConfig
extends AbstractHdfsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String filenamePrefix;
    private String fileExtension;
    private char separator;
    private long syncInterval;
    private int maxPendingRecords = Integer.MAX_VALUE;
    private String subdirectoryPattern;

    public static HdfsSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (HdfsSinkConfig)mapper.readValue(new File(yamlFile), HdfsSinkConfig.class);
    }

    public static HdfsSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (HdfsSinkConfig)mapper.readValue(mapper.writeValueAsString(map), HdfsSinkConfig.class);
    }

    @Override
    public void validate() {
        super.validate();
        if (StringUtils.isEmpty((String)this.fileExtension) && this.getCompression() == null || StringUtils.isEmpty((String)this.filenamePrefix)) {
            throw new IllegalArgumentException("Required property not set.");
        }
        if (this.syncInterval < 0L) {
            throw new IllegalArgumentException("Sync Interval cannot be negative");
        }
        if (this.maxPendingRecords < 1) {
            throw new IllegalArgumentException("Max Pending Records must be a positive integer");
        }
        if (this.subdirectoryPattern != null) {
            try {
                LocalDateTime.of(2020, 1, 1, 12, 0).format(DateTimeFormatter.ofPattern(this.subdirectoryPattern));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.subdirectoryPattern + " is not a valid pattern: " + e.getMessage());
            }
        }
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public char getSeparator() {
        return this.separator;
    }

    public long getSyncInterval() {
        return this.syncInterval;
    }

    public int getMaxPendingRecords() {
        return this.maxPendingRecords;
    }

    public String getSubdirectoryPattern() {
        return this.subdirectoryPattern;
    }

    public HdfsSinkConfig setFilenamePrefix(String filenamePrefix) {
        this.filenamePrefix = filenamePrefix;
        return this;
    }

    public HdfsSinkConfig setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    public HdfsSinkConfig setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public HdfsSinkConfig setSyncInterval(long syncInterval) {
        this.syncInterval = syncInterval;
        return this;
    }

    public HdfsSinkConfig setMaxPendingRecords(int maxPendingRecords) {
        this.maxPendingRecords = maxPendingRecords;
        return this;
    }

    public HdfsSinkConfig setSubdirectoryPattern(String subdirectoryPattern) {
        this.subdirectoryPattern = subdirectoryPattern;
        return this;
    }

    @Override
    public String toString() {
        return "HdfsSinkConfig(filenamePrefix=" + this.getFilenamePrefix() + ", fileExtension=" + this.getFileExtension() + ", separator=" + this.getSeparator() + ", syncInterval=" + this.getSyncInterval() + ", maxPendingRecords=" + this.getMaxPendingRecords() + ", subdirectoryPattern=" + this.getSubdirectoryPattern() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsSinkConfig)) {
            return false;
        }
        HdfsSinkConfig other = (HdfsSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeparator() != other.getSeparator()) {
            return false;
        }
        if (this.getSyncInterval() != other.getSyncInterval()) {
            return false;
        }
        if (this.getMaxPendingRecords() != other.getMaxPendingRecords()) {
            return false;
        }
        String this$filenamePrefix = this.getFilenamePrefix();
        String other$filenamePrefix = other.getFilenamePrefix();
        if (this$filenamePrefix == null ? other$filenamePrefix != null : !this$filenamePrefix.equals(other$filenamePrefix)) {
            return false;
        }
        String this$fileExtension = this.getFileExtension();
        String other$fileExtension = other.getFileExtension();
        if (this$fileExtension == null ? other$fileExtension != null : !this$fileExtension.equals(other$fileExtension)) {
            return false;
        }
        String this$subdirectoryPattern = this.getSubdirectoryPattern();
        String other$subdirectoryPattern = other.getSubdirectoryPattern();
        return !(this$subdirectoryPattern == null ? other$subdirectoryPattern != null : !this$subdirectoryPattern.equals(other$subdirectoryPattern));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HdfsSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSeparator();
        long $syncInterval = this.getSyncInterval();
        result = result * 59 + (int)($syncInterval >>> 32 ^ $syncInterval);
        result = result * 59 + this.getMaxPendingRecords();
        String $filenamePrefix = this.getFilenamePrefix();
        result = result * 59 + ($filenamePrefix == null ? 43 : $filenamePrefix.hashCode());
        String $fileExtension = this.getFileExtension();
        result = result * 59 + ($fileExtension == null ? 43 : $fileExtension.hashCode());
        String $subdirectoryPattern = this.getSubdirectoryPattern();
        result = result * 59 + ($subdirectoryPattern == null ? 43 : $subdirectoryPattern.hashCode());
        return result;
    }
}

