/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.influxdb;

import java.util.Map;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.influxdb.v2.InfluxDBSink;
import org.apache.pulsar.io.influxdb.v2.InfluxDBSinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Connector(name="influxdb", type=IOType.SINK, help="The InfluxDBGenericRecordSink is used for moving messages from Pulsar to InfluxDB.", configClass=InfluxDBSinkConfig.class)
public class InfluxDBGenericRecordSink
implements Sink<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBGenericRecordSink.class);
    protected Sink<GenericRecord> sink;

    public void open(Map<String, Object> map, SinkContext sinkContext) throws Exception {
        try {
            InfluxDBSinkConfig configV2 = InfluxDBSinkConfig.load(map);
            configV2.validate();
            this.sink = new InfluxDBSink();
        }
        catch (Exception e) {
            try {
                org.apache.pulsar.io.influxdb.v1.InfluxDBSinkConfig configV1 = org.apache.pulsar.io.influxdb.v1.InfluxDBSinkConfig.load(map);
                configV1.validate();
                this.sink = new org.apache.pulsar.io.influxdb.v1.InfluxDBGenericRecordSink();
            }
            catch (Exception e1) {
                throw new Exception("For InfluxDB V2: \n" + e.toString() + "\nFor InfluxDB V1: \n" + e1.toString());
            }
        }
        this.sink.open(map, sinkContext);
    }

    public void write(Record<GenericRecord> record) throws Exception {
        this.sink.write(record);
    }

    public void close() throws Exception {
        this.sink.close();
    }
}

