/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.io.core.annotations.Connector;
import org.apache.pulsar.io.core.annotations.IOType;
import org.apache.pulsar.io.jdbc.BaseJdbcAutoSchemaSink;
import org.apache.pulsar.io.jdbc.JdbcSinkConfig;
import org.apache.pulsar.io.jdbc.JdbcUtils;

@Connector(name="jdbc-mariadb", type=IOType.SINK, help="A simple JDBC sink for MariaDB that writes pulsar messages to a database table", configClass=JdbcSinkConfig.class)
public class MariadbJdbcAutoSchemaSink
extends BaseJdbcAutoSchemaSink {
    public String generateUpsertQueryStatement() {
        return JdbcUtils.buildInsertSql((JdbcUtils.TableDefinition)this.tableDefinition) + "ON DUPLICATE KEY UPDATE " + JdbcUtils.buildUpdateSqlSetPart((JdbcUtils.TableDefinition)this.tableDefinition);
    }

    public List<JdbcUtils.ColumnId> getColumnsForUpsert() {
        ArrayList<JdbcUtils.ColumnId> columns = new ArrayList<JdbcUtils.ColumnId>();
        columns.addAll(this.tableDefinition.getColumns());
        columns.addAll(this.tableDefinition.getNonKeyColumns());
        return columns;
    }
}

