/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.solr;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.solr.SolrSinkConfig;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrAbstractSink<T>
implements Sink<T> {
    private static final Logger log = LoggerFactory.getLogger(SolrAbstractSink.class);
    private SolrSinkConfig solrSinkConfig;
    private SolrClient client;
    private boolean enableBasicAuth;

    public void open(Map<String, Object> config, SinkContext sinkContext) throws Exception {
        SolrMode solrMode;
        this.solrSinkConfig = SolrSinkConfig.load(config, sinkContext);
        this.solrSinkConfig.validate();
        this.enableBasicAuth = !Strings.isNullOrEmpty((String)this.solrSinkConfig.getUsername());
        try {
            solrMode = SolrMode.valueOf(this.solrSinkConfig.getSolrMode().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal Solr mode, valid values are: " + Arrays.asList(SolrMode.values()));
        }
        this.client = SolrAbstractSink.getClient(solrMode, this.solrSinkConfig.getSolrUrl());
    }

    public void write(Record<T> record) {
        UpdateRequest updateRequest = new UpdateRequest();
        if (this.solrSinkConfig.getSolrCommitWithinMs() > 0) {
            updateRequest.setCommitWithin(this.solrSinkConfig.getSolrCommitWithinMs());
        }
        if (this.enableBasicAuth) {
            updateRequest.setBasicAuthCredentials(this.solrSinkConfig.getUsername(), this.solrSinkConfig.getPassword());
        }
        SolrInputDocument document = this.convert(record);
        updateRequest.add(document);
        try {
            UpdateResponse updateResponse = (UpdateResponse)updateRequest.process(this.client, this.solrSinkConfig.getSolrCollection());
            if (updateResponse.getStatus() == 0) {
                record.ack();
            } else {
                record.fail();
            }
        }
        catch (IOException | SolrServerException e) {
            record.fail();
            log.warn("Solr update document exception ", e);
        }
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }

    public abstract SolrInputDocument convert(Record<T> var1);

    public static SolrClient getClient(SolrMode solrMode, String url) {
        HttpSolrClient solrClient = null;
        if (solrMode.equals((Object)SolrMode.STANDALONE)) {
            HttpSolrClient.Builder builder = new HttpSolrClient.Builder(url);
            solrClient = builder.build();
        }
        if (solrMode.equals((Object)SolrMode.SOLRCLOUD)) {
            int chrootIndex = url.indexOf("/");
            Optional<Object> chroot = Optional.empty();
            if (chrootIndex > 0) {
                chroot = Optional.of(url.substring(chrootIndex));
            }
            String zkUrls = chrootIndex > 0 ? url.substring(0, chrootIndex) : url;
            List<String> zkHosts = Arrays.asList(zkUrls.split(","));
            CloudSolrClient.Builder builder = new CloudSolrClient.Builder(zkHosts, chroot);
            solrClient = builder.build();
        }
        return solrClient;
    }

    public static enum SolrMode {
        STANDALONE,
        SOLRCLOUD;

    }
}

